package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowId,
  OwnerInformation,
  ClientToken,
  MaintenanceWindowName,
  MaintenanceWindowDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterTargetWithMaintenanceWindowRequest(
    windowId: MaintenanceWindowId,
    resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType,
    targets: Iterable[zio.aws.ssm.model.Target],
    ownerInformation: Option[OwnerInformation] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest = {
    import RegisterTargetWithMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest
      .wrap(buildAwsValue())
}
object RegisterTargetWithMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest =
      zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest(
        windowId,
        resourceType,
        targets.map { item =>
          item.asEditable
        },
        ownerInformation.map(value => value),
        name.map(value => value),
        description.map(value => value),
        clientToken.map(value => value)
      )
    def windowId: MaintenanceWindowId
    def resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType
    def targets: List[zio.aws.ssm.model.Target.ReadOnly]
    def ownerInformation: Option[OwnerInformation]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def clientToken: Option[ClientToken]
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ssm.model.MaintenanceWindowResourceType] =
      ZIO.succeed(resourceType)
    def getTargets: ZIO[Any, Nothing, List[zio.aws.ssm.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType =
      zio.aws.ssm.model.MaintenanceWindowResourceType.wrap(impl.resourceType())
    override val targets: List[zio.aws.ssm.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.ssm.model.Target.wrap(item)
      }
      .toList
    override val ownerInformation: Option[OwnerInformation] = scala
      .Option(impl.ownerInformation())
      .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest
  ): zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest.ReadOnly =
    new Wrapper(impl)
}
