package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BatchErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FailedCreateAssociation(
    entry: Option[zio.aws.ssm.model.CreateAssociationBatchRequestEntry] = None,
    message: Option[BatchErrorMessage] = None,
    fault: Option[zio.aws.ssm.model.Fault] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.FailedCreateAssociation = {
    import FailedCreateAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.FailedCreateAssociation
      .builder()
      .optionallyWith(entry.map(value => value.buildAwsValue()))(_.entry)
      .optionallyWith(
        message.map(value => BatchErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(fault.map(value => value.unwrap))(_.fault)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.FailedCreateAssociation.ReadOnly =
    zio.aws.ssm.model.FailedCreateAssociation.wrap(buildAwsValue())
}
object FailedCreateAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.FailedCreateAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.FailedCreateAssociation =
      zio.aws.ssm.model.FailedCreateAssociation(
        entry.map(value => value.asEditable),
        message.map(value => value),
        fault.map(value => value)
      )
    def entry
        : Option[zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly]
    def message: Option[BatchErrorMessage]
    def fault: Option[zio.aws.ssm.model.Fault]
    def getEntry: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly
    ] = AwsError.unwrapOptionField("entry", entry)
    def getMessage: ZIO[Any, AwsError, BatchErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getFault: ZIO[Any, AwsError, zio.aws.ssm.model.Fault] =
      AwsError.unwrapOptionField("fault", fault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.FailedCreateAssociation
  ) extends zio.aws.ssm.model.FailedCreateAssociation.ReadOnly {
    override val entry: Option[
      zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly
    ] = scala
      .Option(impl.entry())
      .map(value =>
        zio.aws.ssm.model.CreateAssociationBatchRequestEntry.wrap(value)
      )
    override val message: Option[BatchErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.ssm.model.primitives.BatchErrorMessage(value))
    override val fault: Option[zio.aws.ssm.model.Fault] = scala
      .Option(impl.fault())
      .map(value => zio.aws.ssm.model.Fault.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.FailedCreateAssociation
  ): zio.aws.ssm.model.FailedCreateAssociation.ReadOnly = new Wrapper(impl)
}
