package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOpsItemsResponse(
    nextToken: Option[String] = None,
    opsItemSummaries: Option[Iterable[zio.aws.ssm.model.OpsItemSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse = {
    import DescribeOpsItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        opsItemSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.opsItemSummaries)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeOpsItemsResponse.wrap(buildAwsValue())
}
object DescribeOpsItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeOpsItemsResponse =
      zio.aws.ssm.model.DescribeOpsItemsResponse(
        nextToken.map(value => value),
        opsItemSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def opsItemSummaries
        : Option[List[zio.aws.ssm.model.OpsItemSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOpsItemSummaries
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsItemSummary.ReadOnly]] =
      AwsError.unwrapOptionField("opsItemSummaries", opsItemSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse
  ) extends zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val opsItemSummaries
        : Option[List[zio.aws.ssm.model.OpsItemSummary.ReadOnly]] = scala
      .Option(impl.opsItemSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse
  ): zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly = new Wrapper(impl)
}
