package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchStringDateTime, ApproveAfterDays}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PatchRule(
    patchFilterGroup: zio.aws.ssm.model.PatchFilterGroup,
    complianceLevel: Option[zio.aws.ssm.model.PatchComplianceLevel] = None,
    approveAfterDays: Option[ApproveAfterDays] = None,
    approveUntilDate: Option[PatchStringDateTime] = None,
    enableNonSecurity: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.PatchRule = {
    import PatchRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchRule
      .builder()
      .patchFilterGroup(patchFilterGroup.buildAwsValue())
      .optionallyWith(complianceLevel.map(value => value.unwrap))(
        _.complianceLevel
      )
      .optionallyWith(
        approveAfterDays.map(value => ApproveAfterDays.unwrap(value): Integer)
      )(_.approveAfterDays)
      .optionallyWith(
        approveUntilDate.map(value =>
          PatchStringDateTime.unwrap(value): java.lang.String
        )
      )(_.approveUntilDate)
      .optionallyWith(enableNonSecurity.map(value => value: java.lang.Boolean))(
        _.enableNonSecurity
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchRule.ReadOnly =
    zio.aws.ssm.model.PatchRule.wrap(buildAwsValue())
}
object PatchRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.PatchRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchRule = zio.aws.ssm.model.PatchRule(
      patchFilterGroup.asEditable,
      complianceLevel.map(value => value),
      approveAfterDays.map(value => value),
      approveUntilDate.map(value => value),
      enableNonSecurity.map(value => value)
    )
    def patchFilterGroup: zio.aws.ssm.model.PatchFilterGroup.ReadOnly
    def complianceLevel: Option[zio.aws.ssm.model.PatchComplianceLevel]
    def approveAfterDays: Option[ApproveAfterDays]
    def approveUntilDate: Option[PatchStringDateTime]
    def enableNonSecurity: Option[Boolean]
    def getPatchFilterGroup
        : ZIO[Any, Nothing, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      ZIO.succeed(patchFilterGroup)
    def getComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField("complianceLevel", complianceLevel)
    def getApproveAfterDays: ZIO[Any, AwsError, ApproveAfterDays] =
      AwsError.unwrapOptionField("approveAfterDays", approveAfterDays)
    def getApproveUntilDate: ZIO[Any, AwsError, PatchStringDateTime] =
      AwsError.unwrapOptionField("approveUntilDate", approveUntilDate)
    def getEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableNonSecurity", enableNonSecurity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchRule
  ) extends zio.aws.ssm.model.PatchRule.ReadOnly {
    override val patchFilterGroup: zio.aws.ssm.model.PatchFilterGroup.ReadOnly =
      zio.aws.ssm.model.PatchFilterGroup.wrap(impl.patchFilterGroup())
    override val complianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel] = scala
      .Option(impl.complianceLevel())
      .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approveAfterDays: Option[ApproveAfterDays] = scala
      .Option(impl.approveAfterDays())
      .map(value => zio.aws.ssm.model.primitives.ApproveAfterDays(value))
    override val approveUntilDate: Option[PatchStringDateTime] = scala
      .Option(impl.approveUntilDate())
      .map(value => zio.aws.ssm.model.primitives.PatchStringDateTime(value))
    override val enableNonSecurity: Option[Boolean] =
      scala.Option(impl.enableNonSecurity()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchRule
  ): zio.aws.ssm.model.PatchRule.ReadOnly = new Wrapper(impl)
}
