package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentHash,
  Comment,
  ParameterName,
  ParameterValue,
  TimeoutSeconds,
  DocumentVersion,
  S3KeyPrefix,
  S3BucketName,
  ServiceRole
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowRunCommandParameters(
    comment: Option[Comment] = None,
    cloudWatchOutputConfig: Option[zio.aws.ssm.model.CloudWatchOutputConfig] =
      None,
    documentHash: Option[DocumentHash] = None,
    documentHashType: Option[zio.aws.ssm.model.DocumentHashType] = None,
    documentVersion: Option[DocumentVersion] = None,
    notificationConfig: Option[zio.aws.ssm.model.NotificationConfig] = None,
    outputS3BucketName: Option[S3BucketName] = None,
    outputS3KeyPrefix: Option[S3KeyPrefix] = None,
    parameters: Option[Map[ParameterName, Iterable[ParameterValue]]] = None,
    serviceRoleArn: Option[ServiceRole] = None,
    timeoutSeconds: Option[TimeoutSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters = {
    import MaintenanceWindowRunCommandParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
      .builder()
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .optionallyWith(
        documentHash.map(value => DocumentHash.unwrap(value): java.lang.String)
      )(_.documentHash)
      .optionallyWith(documentHashType.map(value => value.unwrap))(
        _.documentHashType
      )
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        timeoutSeconds.map(value => TimeoutSeconds.unwrap(value): Integer)
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowRunCommandParameters
      .wrap(buildAwsValue())
}
object MaintenanceWindowRunCommandParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowRunCommandParameters =
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters(
        comment.map(value => value),
        cloudWatchOutputConfig.map(value => value.asEditable),
        documentHash.map(value => value),
        documentHashType.map(value => value),
        documentVersion.map(value => value),
        notificationConfig.map(value => value.asEditable),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value),
        parameters.map(value => value),
        serviceRoleArn.map(value => value),
        timeoutSeconds.map(value => value)
      )
    def comment: Option[Comment]
    def cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def documentHash: Option[DocumentHash]
    def documentHashType: Option[zio.aws.ssm.model.DocumentHashType]
    def documentVersion: Option[DocumentVersion]
    def notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def outputS3BucketName: Option[S3BucketName]
    def outputS3KeyPrefix: Option[S3KeyPrefix]
    def parameters: Option[Map[ParameterName, List[ParameterValue]]]
    def serviceRoleArn: Option[ServiceRole]
    def timeoutSeconds: Option[TimeoutSeconds]
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
    def getDocumentHash: ZIO[Any, AwsError, DocumentHash] =
      AwsError.unwrapOptionField("documentHash", documentHash)
    def getDocumentHashType
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentHashType] =
      AwsError.unwrapOptionField("documentHashType", documentHashType)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTimeoutSeconds: ZIO[Any, AwsError, TimeoutSeconds] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly {
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] = scala
      .Option(impl.cloudWatchOutputConfig())
      .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
    override val documentHash: Option[DocumentHash] = scala
      .Option(impl.documentHash())
      .map(value => zio.aws.ssm.model.primitives.DocumentHash(value))
    override val documentHashType: Option[zio.aws.ssm.model.DocumentHashType] =
      scala
        .Option(impl.documentHashType())
        .map(value => zio.aws.ssm.model.DocumentHashType.wrap(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly] = scala
      .Option(impl.notificationConfig())
      .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val outputS3BucketName: Option[S3BucketName] = scala
      .Option(impl.outputS3BucketName())
      .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.outputS3KeyPrefix())
      .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
    override val parameters: Option[Map[ParameterName, List[ParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val serviceRoleArn: Option[ServiceRole] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val timeoutSeconds: Option[TimeoutSeconds] = scala
      .Option(impl.timeoutSeconds())
      .map(value => zio.aws.ssm.model.primitives.TimeoutSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ): zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly =
    new Wrapper(impl)
}
