package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskTargetId,
  MaintenanceWindowExecutionId,
  OwnerInformation,
  MaintenanceWindowExecutionTaskInvocationParameters,
  DateTime,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionTaskExecutionId,
  MaintenanceWindowExecutionTaskInvocationId,
  MaintenanceWindowExecutionStatusDetails
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowExecutionTaskInvocationResponse(
    windowExecutionId: Option[MaintenanceWindowExecutionId] = None,
    taskExecutionId: Option[MaintenanceWindowExecutionTaskId] = None,
    invocationId: Option[MaintenanceWindowExecutionTaskInvocationId] = None,
    executionId: Option[MaintenanceWindowExecutionTaskExecutionId] = None,
    taskType: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] = None,
    parameters: Option[MaintenanceWindowExecutionTaskInvocationParameters] =
      None,
    status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = None,
    statusDetails: Option[MaintenanceWindowExecutionStatusDetails] = None,
    startTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None,
    ownerInformation: Option[OwnerInformation] = None,
    windowTargetId: Option[MaintenanceWindowTaskTargetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse = {
    import GetMaintenanceWindowExecutionTaskInvocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskExecutionId.map(value =>
          MaintenanceWindowExecutionTaskId.unwrap(value): java.lang.String
        )
      )(_.taskExecutionId)
      .optionallyWith(
        invocationId.map(value =>
          MaintenanceWindowExecutionTaskInvocationId.unwrap(
            value
          ): java.lang.String
        )
      )(_.invocationId)
      .optionallyWith(
        executionId.map(value =>
          MaintenanceWindowExecutionTaskExecutionId.unwrap(
            value
          ): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .optionallyWith(
        parameters.map(value =>
          MaintenanceWindowExecutionTaskInvocationParameters.unwrap(
            value
          ): java.lang.String
        )
      )(_.parameters)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTaskTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskInvocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse(
        windowExecutionId.map(value => value),
        taskExecutionId.map(value => value),
        invocationId.map(value => value),
        executionId.map(value => value),
        taskType.map(value => value),
        parameters.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        ownerInformation.map(value => value),
        windowTargetId.map(value => value)
      )
    def windowExecutionId: Option[MaintenanceWindowExecutionId]
    def taskExecutionId: Option[MaintenanceWindowExecutionTaskId]
    def invocationId: Option[MaintenanceWindowExecutionTaskInvocationId]
    def executionId: Option[MaintenanceWindowExecutionTaskExecutionId]
    def taskType: Option[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def parameters: Option[MaintenanceWindowExecutionTaskInvocationParameters]
    def status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Option[MaintenanceWindowExecutionStatusDetails]
    def startTime: Option[DateTime]
    def endTime: Option[DateTime]
    def ownerInformation: Option[OwnerInformation]
    def windowTargetId: Option[MaintenanceWindowTaskTargetId]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskId] =
      AwsError.unwrapOptionField("taskExecutionId", taskExecutionId)
    def getInvocationId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskInvocationId] =
      AwsError.unwrapOptionField("invocationId", invocationId)
    def getExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getTaskType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
    def getParameters: ZIO[
      Any,
      AwsError,
      MaintenanceWindowExecutionTaskInvocationParameters
    ] = AwsError.unwrapOptionField("parameters", parameters)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTaskTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly {
    override val windowExecutionId: Option[MaintenanceWindowExecutionId] = scala
      .Option(impl.windowExecutionId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
      )
    override val taskExecutionId: Option[MaintenanceWindowExecutionTaskId] =
      scala
        .Option(impl.taskExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(value)
        )
    override val invocationId
        : Option[MaintenanceWindowExecutionTaskInvocationId] = scala
      .Option(impl.invocationId())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionTaskInvocationId(value)
      )
    override val executionId
        : Option[MaintenanceWindowExecutionTaskExecutionId] = scala
      .Option(impl.executionId())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionTaskExecutionId(value)
      )
    override val taskType: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      scala
        .Option(impl.taskType())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
    override val parameters
        : Option[MaintenanceWindowExecutionTaskInvocationParameters] = scala
      .Option(impl.parameters())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionTaskInvocationParameters(value)
      )
    override val status
        : Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
      )
    override val statusDetails
        : Option[MaintenanceWindowExecutionStatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionStatusDetails(value)
      )
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val ownerInformation: Option[OwnerInformation] = scala
      .Option(impl.ownerInformation())
      .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val windowTargetId: Option[MaintenanceWindowTaskTargetId] = scala
      .Option(impl.windowTargetId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskTargetId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly =
    new Wrapper(impl)
}
