package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{DocumentVersion, DocumentARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentRequires(
    name: DocumentARN,
    version: Option[DocumentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentRequires = {
    import DocumentRequires.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentRequires
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => DocumentVersion.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentRequires.ReadOnly =
    zio.aws.ssm.model.DocumentRequires.wrap(buildAwsValue())
}
object DocumentRequires {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentRequires
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentRequires =
      zio.aws.ssm.model.DocumentRequires(name, version.map(value => value))
    def name: DocumentARN
    def version: Option[DocumentVersion]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentRequires
  ) extends zio.aws.ssm.model.DocumentRequires.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val version: Option[DocumentVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentRequires
  ): zio.aws.ssm.model.DocumentRequires.ReadOnly = new Wrapper(impl)
}
