package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PatchComplianceMaxResults,
  NextToken,
  PatchGroup
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeInstancePatchStatesForPatchGroupRequest(
    patchGroup: PatchGroup,
    filters: Option[Iterable[zio.aws.ssm.model.InstancePatchStateFilter]] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[PatchComplianceMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest = {
    import DescribeInstancePatchStatesForPatchGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
      .builder()
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          PatchComplianceMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
      .wrap(buildAwsValue())
}
object DescribeInstancePatchStatesForPatchGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest =
      zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest(
        patchGroup,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def patchGroup: PatchGroup
    def filters
        : Option[List[zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[PatchComplianceMaxResults]
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PatchComplianceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ) extends zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly {
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
    override val filters
        : Option[List[zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstancePatchStateFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[PatchComplianceMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchComplianceMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly =
    new Wrapper(impl)
}
