package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAssociationExecutionsResponse(
    associationExecutions: Option[
      Iterable[zio.aws.ssm.model.AssociationExecution]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse = {
    import DescribeAssociationExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse
      .builder()
      .optionallyWith(
        associationExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationExecutionsResponse
      .wrap(buildAwsValue())
}
object DescribeAssociationExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAssociationExecutionsResponse =
      zio.aws.ssm.model.DescribeAssociationExecutionsResponse(
        associationExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associationExecutions
        : Option[List[zio.aws.ssm.model.AssociationExecution.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAssociationExecutions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationExecution.ReadOnly
    ]] =
      AwsError.unwrapOptionField("associationExecutions", associationExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse
  ) extends zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly {
    override val associationExecutions
        : Option[List[zio.aws.ssm.model.AssociationExecution.ReadOnly]] = scala
      .Option(impl.associationExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AssociationExecution.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse
  ): zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
