package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePatchBaselineResponse(
    baselineId: Option[BaselineId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse = {
    import CreatePatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.CreatePatchBaselineResponse.wrap(buildAwsValue())
}
object CreatePatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreatePatchBaselineResponse =
      zio.aws.ssm.model
        .CreatePatchBaselineResponse(baselineId.map(value => value))
    def baselineId: Option[BaselineId]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse
  ) extends zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly {
    override val baselineId: Option[BaselineId] = scala
      .Option(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse
  ): zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly = new Wrapper(impl)
}
