package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateMaintenanceWindowResponse(
    windowId: Option[MaintenanceWindowId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse = {
    import CreateMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.CreateMaintenanceWindowResponse.wrap(buildAwsValue())
}
object CreateMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateMaintenanceWindowResponse =
      zio.aws.ssm.model
        .CreateMaintenanceWindowResponse(windowId.map(value => value))
    def windowId: Option[MaintenanceWindowId]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse
  ): zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly = new Wrapper(
    impl
  )
}
