package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  BaselineDescription,
  PatchId,
  BaselineName,
  BaselineId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePatchBaselineRequest(
    baselineId: BaselineId,
    name: Option[BaselineName] = None,
    globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup] = None,
    approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup] = None,
    approvedPatches: Option[Iterable[PatchId]] = None,
    approvedPatchesComplianceLevel: Option[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = None,
    approvedPatchesEnableNonSecurity: Option[Boolean] = None,
    rejectedPatches: Option[Iterable[PatchId]] = None,
    rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] = None,
    description: Option[BaselineDescription] = None,
    sources: Option[Iterable[zio.aws.ssm.model.PatchSource]] = None,
    replace: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest = {
    import UpdatePatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .optionallyWith(
        name.map(value => BaselineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        description.map(value =>
          BaselineDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(replace.map(value => value: java.lang.Boolean))(_.replace)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.UpdatePatchBaselineRequest.wrap(buildAwsValue())
}
object UpdatePatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdatePatchBaselineRequest =
      zio.aws.ssm.model.UpdatePatchBaselineRequest(
        baselineId,
        name.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        description.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replace.map(value => value)
      )
    def baselineId: BaselineId
    def name: Option[BaselineName]
    def globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Option[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel]
    def approvedPatchesEnableNonSecurity: Option[Boolean]
    def rejectedPatches: Option[List[PatchId]]
    def rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction]
    def description: Option[BaselineDescription]
    def sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def replace: Option[Boolean]
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getName: ZIO[Any, AwsError, BaselineName] =
      AwsError.unwrapOptionField("name", name)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getDescription: ZIO[Any, AwsError, BaselineDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
    def getReplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("replace", replace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ) extends zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val name: Option[BaselineName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.BaselineName(value))
    override val globalFilters
        : Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] = scala
      .Option(impl.globalFilters())
      .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] = scala
      .Option(impl.approvalRules())
      .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Option[List[PatchId]] = scala
      .Option(impl.approvedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel] = scala
      .Option(impl.approvedPatchesComplianceLevel())
      .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvedPatchesEnableNonSecurity: Option[Boolean] = scala
      .Option(impl.approvedPatchesEnableNonSecurity())
      .map(value => value: Boolean)
    override val rejectedPatches: Option[List[PatchId]] = scala
      .Option(impl.rejectedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] =
      scala
        .Option(impl.rejectedPatchesAction())
        .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val description: Option[BaselineDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.BaselineDescription(value))
    override val sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      scala
        .Option(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
    override val replace: Option[Boolean] =
      scala.Option(impl.replace()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest
  ): zio.aws.ssm.model.UpdatePatchBaselineRequest.ReadOnly = new Wrapper(impl)
}
