package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStringDateTime,
  MaintenanceWindowOffset,
  MaintenanceWindowId,
  MaintenanceWindowTimezone,
  MaintenanceWindowCutoff,
  MaintenanceWindowSchedule,
  MaintenanceWindowDurationHours,
  MaintenanceWindowEnabled,
  MaintenanceWindowName,
  MaintenanceWindowAllowUnassociatedTargets,
  MaintenanceWindowDescription
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMaintenanceWindowResponse(
    windowId: Option[MaintenanceWindowId] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    startDate: Option[MaintenanceWindowStringDateTime] = None,
    endDate: Option[MaintenanceWindowStringDateTime] = None,
    schedule: Option[MaintenanceWindowSchedule] = None,
    scheduleTimezone: Option[MaintenanceWindowTimezone] = None,
    scheduleOffset: Option[MaintenanceWindowOffset] = None,
    duration: Option[MaintenanceWindowDurationHours] = None,
    cutoff: Option[MaintenanceWindowCutoff] = None,
    allowUnassociatedTargets: Option[
      MaintenanceWindowAllowUnassociatedTargets
    ] = None,
    enabled: Option[MaintenanceWindowEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse = {
    import UpdateMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.startDate)
      .optionallyWith(
        endDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.endDate)
      .optionallyWith(
        schedule.map(value =>
          MaintenanceWindowSchedule.unwrap(value): java.lang.String
        )
      )(_.schedule)
      .optionallyWith(
        scheduleTimezone.map(value =>
          MaintenanceWindowTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleTimezone)
      .optionallyWith(
        scheduleOffset.map(value =>
          MaintenanceWindowOffset.unwrap(value): Integer
        )
      )(_.scheduleOffset)
      .optionallyWith(
        duration.map(value =>
          MaintenanceWindowDurationHours.unwrap(value): Integer
        )
      )(_.duration)
      .optionallyWith(
        cutoff.map(value => MaintenanceWindowCutoff.unwrap(value): Integer)
      )(_.cutoff)
      .optionallyWith(
        allowUnassociatedTargets.map(value =>
          MaintenanceWindowAllowUnassociatedTargets.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.allowUnassociatedTargets)
      .optionallyWith(
        enabled.map(value =>
          MaintenanceWindowEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.UpdateMaintenanceWindowResponse.wrap(buildAwsValue())
}
object UpdateMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateMaintenanceWindowResponse =
      zio.aws.ssm.model.UpdateMaintenanceWindowResponse(
        windowId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        schedule.map(value => value),
        scheduleTimezone.map(value => value),
        scheduleOffset.map(value => value),
        duration.map(value => value),
        cutoff.map(value => value),
        allowUnassociatedTargets.map(value => value),
        enabled.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def startDate: Option[MaintenanceWindowStringDateTime]
    def endDate: Option[MaintenanceWindowStringDateTime]
    def schedule: Option[MaintenanceWindowSchedule]
    def scheduleTimezone: Option[MaintenanceWindowTimezone]
    def scheduleOffset: Option[MaintenanceWindowOffset]
    def duration: Option[MaintenanceWindowDurationHours]
    def cutoff: Option[MaintenanceWindowCutoff]
    def allowUnassociatedTargets
        : Option[MaintenanceWindowAllowUnassociatedTargets]
    def enabled: Option[MaintenanceWindowEnabled]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getSchedule: ZIO[Any, AwsError, MaintenanceWindowSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getScheduleTimezone: ZIO[Any, AwsError, MaintenanceWindowTimezone] =
      AwsError.unwrapOptionField("scheduleTimezone", scheduleTimezone)
    def getScheduleOffset: ZIO[Any, AwsError, MaintenanceWindowOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getDuration: ZIO[Any, AwsError, MaintenanceWindowDurationHours] =
      AwsError.unwrapOptionField("duration", duration)
    def getCutoff: ZIO[Any, AwsError, MaintenanceWindowCutoff] =
      AwsError.unwrapOptionField("cutoff", cutoff)
    def getAllowUnassociatedTargets
        : ZIO[Any, AwsError, MaintenanceWindowAllowUnassociatedTargets] =
      AwsError.unwrapOptionField(
        "allowUnassociatedTargets",
        allowUnassociatedTargets
      )
    def getEnabled: ZIO[Any, AwsError, MaintenanceWindowEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val startDate: Option[MaintenanceWindowStringDateTime] = scala
      .Option(impl.startDate())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
      )
    override val endDate: Option[MaintenanceWindowStringDateTime] = scala
      .Option(impl.endDate())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
      )
    override val schedule: Option[MaintenanceWindowSchedule] = scala
      .Option(impl.schedule())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowSchedule(value)
      )
    override val scheduleTimezone: Option[MaintenanceWindowTimezone] = scala
      .Option(impl.scheduleTimezone())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTimezone(value)
      )
    override val scheduleOffset: Option[MaintenanceWindowOffset] = scala
      .Option(impl.scheduleOffset())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowOffset(value))
    override val duration: Option[MaintenanceWindowDurationHours] = scala
      .Option(impl.duration())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDurationHours(value)
      )
    override val cutoff: Option[MaintenanceWindowCutoff] = scala
      .Option(impl.cutoff())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowCutoff(value))
    override val allowUnassociatedTargets
        : Option[MaintenanceWindowAllowUnassociatedTargets] = scala
      .Option(impl.allowUnassociatedTargets())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowAllowUnassociatedTargets(value)
      )
    override val enabled: Option[MaintenanceWindowEnabled] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowEnabled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ): zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly = new Wrapper(
    impl
  )
}
