package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OpsItemEventSummary(
    opsItemId: Option[String] = None,
    eventId: Option[String] = None,
    source: Option[String] = None,
    detailType: Option[String] = None,
    detail: Option[String] = None,
    createdBy: Option[zio.aws.ssm.model.OpsItemIdentity] = None,
    createdTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemEventSummary = {
    import OpsItemEventSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
      .builder()
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(detailType.map(value => value: java.lang.String))(
        _.detailType
      )
      .optionallyWith(detail.map(value => value: java.lang.String))(_.detail)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemEventSummary.ReadOnly =
    zio.aws.ssm.model.OpsItemEventSummary.wrap(buildAwsValue())
}
object OpsItemEventSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemEventSummary =
      zio.aws.ssm.model.OpsItemEventSummary(
        opsItemId.map(value => value),
        eventId.map(value => value),
        source.map(value => value),
        detailType.map(value => value),
        detail.map(value => value),
        createdBy.map(value => value.asEditable),
        createdTime.map(value => value)
      )
    def opsItemId: Option[String]
    def eventId: Option[String]
    def source: Option[String]
    def detailType: Option[String]
    def detail: Option[String]
    def createdBy: Option[zio.aws.ssm.model.OpsItemIdentity.ReadOnly]
    def createdTime: Option[DateTime]
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detail", detail)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ) extends zio.aws.ssm.model.OpsItemEventSummary.ReadOnly {
    override val opsItemId: Option[String] =
      scala.Option(impl.opsItemId()).map(value => value: String)
    override val eventId: Option[String] =
      scala.Option(impl.eventId()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val detailType: Option[String] =
      scala.Option(impl.detailType()).map(value => value: String)
    override val detail: Option[String] =
      scala.Option(impl.detail()).map(value => value: String)
    override val createdBy: Option[zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      scala
        .Option(impl.createdBy())
        .map(value => zio.aws.ssm.model.OpsItemIdentity.wrap(value))
    override val createdTime: Option[DateTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ): zio.aws.ssm.model.OpsItemEventSummary.ReadOnly = new Wrapper(impl)
}
