package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSessionsResponse(
    sessions: Option[Iterable[zio.aws.ssm.model.Session]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse = {
    import DescribeSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse
      .builder()
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeSessionsResponse.wrap(buildAwsValue())
}
object DescribeSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeSessionsResponse =
      zio.aws.ssm.model.DescribeSessionsResponse(
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sessions: Option[List[zio.aws.ssm.model.Session.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSessions
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Session.ReadOnly]] =
      AwsError.unwrapOptionField("sessions", sessions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse
  ) extends zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly {
    override val sessions: Option[List[zio.aws.ssm.model.Session.ReadOnly]] =
      scala
        .Option(impl.sessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Session.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse
  ): zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly = new Wrapper(impl)
}
