package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersResponse(
    parameters: Option[Iterable[zio.aws.ssm.model.ParameterMetadata]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeParametersResponse = {
    import DescribeParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeParametersResponse.ReadOnly =
    zio.aws.ssm.model.DescribeParametersResponse.wrap(buildAwsValue())
}
object DescribeParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeParametersResponse =
      zio.aws.ssm.model.DescribeParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def parameters: Option[List[zio.aws.ssm.model.ParameterMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParameterMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeParametersResponse
  ) extends zio.aws.ssm.model.DescribeParametersResponse.ReadOnly {
    override val parameters
        : Option[List[zio.aws.ssm.model.ParameterMetadata.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ParameterMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeParametersResponse
  ): zio.aws.ssm.model.DescribeParametersResponse.ReadOnly = new Wrapper(impl)
}
