package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{SharedDocumentVersion, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccountSharingInfo(
    accountId: Option[AccountId] = None,
    sharedDocumentVersion: Option[SharedDocumentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AccountSharingInfo = {
    import AccountSharingInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AccountSharingInfo
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        sharedDocumentVersion.map(value =>
          SharedDocumentVersion.unwrap(value): java.lang.String
        )
      )(_.sharedDocumentVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AccountSharingInfo.ReadOnly =
    zio.aws.ssm.model.AccountSharingInfo.wrap(buildAwsValue())
}
object AccountSharingInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AccountSharingInfo =
      zio.aws.ssm.model.AccountSharingInfo(
        accountId.map(value => value),
        sharedDocumentVersion.map(value => value)
      )
    def accountId: Option[AccountId]
    def sharedDocumentVersion: Option[SharedDocumentVersion]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSharedDocumentVersion: ZIO[Any, AwsError, SharedDocumentVersion] =
      AwsError.unwrapOptionField("sharedDocumentVersion", sharedDocumentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ) extends zio.aws.ssm.model.AccountSharingInfo.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.ssm.model.primitives.AccountId(value))
    override val sharedDocumentVersion: Option[SharedDocumentVersion] = scala
      .Option(impl.sharedDocumentVersion())
      .map(value => zio.aws.ssm.model.primitives.SharedDocumentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ): zio.aws.ssm.model.AccountSharingInfo.ReadOnly = new Wrapper(impl)
}
