package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DateTime,
  OpsMetadataArn,
  OpsMetadataResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OpsMetadata(
    resourceId: Option[OpsMetadataResourceId] = None,
    opsMetadataArn: Option[OpsMetadataArn] = None,
    lastModifiedDate: Option[DateTime] = None,
    lastModifiedUser: Option[String] = None,
    creationDate: Option[DateTime] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsMetadata = {
    import OpsMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsMetadata
      .builder()
      .optionallyWith(
        resourceId.map(value =>
          OpsMetadataResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        opsMetadataArn.map(value =>
          OpsMetadataArn.unwrap(value): java.lang.String
        )
      )(_.opsMetadataArn)
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedUser.map(value => value: java.lang.String))(
        _.lastModifiedUser
      )
      .optionallyWith(
        creationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsMetadata.ReadOnly =
    zio.aws.ssm.model.OpsMetadata.wrap(buildAwsValue())
}
object OpsMetadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsMetadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsMetadata =
      zio.aws.ssm.model.OpsMetadata(
        resourceId.map(value => value),
        opsMetadataArn.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedUser.map(value => value),
        creationDate.map(value => value)
      )
    def resourceId: Option[OpsMetadataResourceId]
    def opsMetadataArn: Option[OpsMetadataArn]
    def lastModifiedDate: Option[DateTime]
    def lastModifiedUser: Option[String]
    def creationDate: Option[DateTime]
    def getResourceId: ZIO[Any, AwsError, OpsMetadataResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getOpsMetadataArn: ZIO[Any, AwsError, OpsMetadataArn] =
      AwsError.unwrapOptionField("opsMetadataArn", opsMetadataArn)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getCreationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadata
  ) extends zio.aws.ssm.model.OpsMetadata.ReadOnly {
    override val resourceId: Option[OpsMetadataResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.ssm.model.primitives.OpsMetadataResourceId(value))
    override val opsMetadataArn: Option[OpsMetadataArn] = scala
      .Option(impl.opsMetadataArn())
      .map(value => zio.aws.ssm.model.primitives.OpsMetadataArn(value))
    override val lastModifiedDate: Option[DateTime] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedUser: Option[String] =
      scala.Option(impl.lastModifiedUser()).map(value => value: String)
    override val creationDate: Option[DateTime] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadata
  ): zio.aws.ssm.model.OpsMetadata.ReadOnly = new Wrapper(impl)
}
