package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentsResponse(
    documentIdentifiers: Option[
      Iterable[zio.aws.ssm.model.DocumentIdentifier]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentsResponse = {
    import ListDocumentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentsResponse
      .builder()
      .optionallyWith(
        documentIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListDocumentsResponse.ReadOnly =
    zio.aws.ssm.model.ListDocumentsResponse.wrap(buildAwsValue())
}
object ListDocumentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentsResponse =
      zio.aws.ssm.model.ListDocumentsResponse(
        documentIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentIdentifiers
        : Option[List[zio.aws.ssm.model.DocumentIdentifier.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDocumentIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("documentIdentifiers", documentIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsResponse
  ) extends zio.aws.ssm.model.ListDocumentsResponse.ReadOnly {
    override val documentIdentifiers
        : Option[List[zio.aws.ssm.model.DocumentIdentifier.ReadOnly]] = scala
      .Option(impl.documentIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentIdentifier.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsResponse
  ): zio.aws.ssm.model.ListDocumentsResponse.ReadOnly = new Wrapper(impl)
}
