package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  AutomationParameterKey,
  DateTime,
  AutomationActionName,
  ValidNextStep
}
import scala.jdk.CollectionConverters.*
final case class StepExecution(
    stepName: Option[String] = None,
    action: Option[AutomationActionName] = None,
    timeoutSeconds: Option[Long] = None,
    onFailure: Option[String] = None,
    maxAttempts: Option[zio.aws.ssm.model.primitives.Integer] = None,
    executionStartTime: Option[DateTime] = None,
    executionEndTime: Option[DateTime] = None,
    stepStatus: Option[zio.aws.ssm.model.AutomationExecutionStatus] = None,
    responseCode: Option[String] = None,
    inputs: Option[Map[String, String]] = None,
    outputs: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    response: Option[String] = None,
    failureMessage: Option[String] = None,
    failureDetails: Option[zio.aws.ssm.model.FailureDetails] = None,
    stepExecutionId: Option[String] = None,
    overriddenParameters: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    isEnd: Option[Boolean] = None,
    nextStep: Option[String] = None,
    isCritical: Option[Boolean] = None,
    validNextSteps: Option[Iterable[ValidNextStep]] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    targetLocation: Option[zio.aws.ssm.model.TargetLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StepExecution = {
    import StepExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StepExecution
      .builder()
      .optionallyWith(stepName.map(value => value: java.lang.String))(
        _.stepName
      )
      .optionallyWith(
        action.map(value =>
          AutomationActionName.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(timeoutSeconds.map(value => value: java.lang.Long))(
        _.timeoutSeconds
      )
      .optionallyWith(onFailure.map(value => value: java.lang.String))(
        _.onFailure
      )
      .optionallyWith(
        maxAttempts.map(value =>
          zio.aws.ssm.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.maxAttempts)
      .optionallyWith(
        executionStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionStartTime)
      .optionallyWith(
        executionEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionEndTime)
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(responseCode.map(value => value: java.lang.String))(
        _.responseCode
      )
      .optionallyWith(
        inputs.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.inputs)
      .optionallyWith(
        outputs.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.outputs)
      .optionallyWith(response.map(value => value: java.lang.String))(
        _.response
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(stepExecutionId.map(value => value: java.lang.String))(
        _.stepExecutionId
      )
      .optionallyWith(
        overriddenParameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.overriddenParameters)
      .optionallyWith(isEnd.map(value => value: java.lang.Boolean))(_.isEnd)
      .optionallyWith(nextStep.map(value => value: java.lang.String))(
        _.nextStep
      )
      .optionallyWith(isCritical.map(value => value: java.lang.Boolean))(
        _.isCritical
      )
      .optionallyWith(
        validNextSteps.map(value =>
          value.map { item =>
            ValidNextStep.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validNextSteps)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(targetLocation.map(value => value.buildAwsValue()))(
        _.targetLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StepExecution.ReadOnly =
    zio.aws.ssm.model.StepExecution.wrap(buildAwsValue())
}
object StepExecution {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.StepExecution] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StepExecution =
      zio.aws.ssm.model.StepExecution(
        stepName.map(value => value),
        action.map(value => value),
        timeoutSeconds.map(value => value),
        onFailure.map(value => value),
        maxAttempts.map(value => value),
        executionStartTime.map(value => value),
        executionEndTime.map(value => value),
        stepStatus.map(value => value),
        responseCode.map(value => value),
        inputs.map(value => value),
        outputs.map(value => value),
        response.map(value => value),
        failureMessage.map(value => value),
        failureDetails.map(value => value.asEditable),
        stepExecutionId.map(value => value),
        overriddenParameters.map(value => value),
        isEnd.map(value => value),
        nextStep.map(value => value),
        isCritical.map(value => value),
        validNextSteps.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetLocation.map(value => value.asEditable)
      )
    def stepName: Option[String]
    def action: Option[AutomationActionName]
    def timeoutSeconds: Option[Long]
    def onFailure: Option[String]
    def maxAttempts: Option[zio.aws.ssm.model.primitives.Integer]
    def executionStartTime: Option[DateTime]
    def executionEndTime: Option[DateTime]
    def stepStatus: Option[zio.aws.ssm.model.AutomationExecutionStatus]
    def responseCode: Option[String]
    def inputs: Option[Map[String, String]]
    def outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def response: Option[String]
    def failureMessage: Option[String]
    def failureDetails: Option[zio.aws.ssm.model.FailureDetails.ReadOnly]
    def stepExecutionId: Option[String]
    def overriddenParameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def isEnd: Option[Boolean]
    def nextStep: Option[String]
    def isCritical: Option[Boolean]
    def validNextSteps: Option[List[ValidNextStep]]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetLocation: Option[zio.aws.ssm.model.TargetLocation.ReadOnly]
    def getStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getAction: ZIO[Any, AwsError, AutomationActionName] =
      AwsError.unwrapOptionField("action", action)
    def getTimeoutSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getOnFailure: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onFailure", onFailure)
    def getMaxAttempts
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("maxAttempts", maxAttempts)
    def getExecutionStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionStartTime", executionStartTime)
    def getExecutionEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionEndTime", executionEndTime)
    def getStepStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecutionStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getResponseCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getInputs: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("inputs", inputs)
    def getOutputs: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("outputs", outputs)
    def getResponse: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("response", response)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailureDetails
        : ZIO[Any, AwsError, zio.aws.ssm.model.FailureDetails.ReadOnly] =
      AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStepExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getOverriddenParameters
        : ZIO[Any, AwsError, Map[AutomationParameterKey, List[
          AutomationParameterValue
        ]]] =
      AwsError.unwrapOptionField("overriddenParameters", overriddenParameters)
    def getIsEnd: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnd", isEnd)
    def getNextStep: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextStep", nextStep)
    def getIsCritical: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCritical", isCritical)
    def getValidNextSteps: ZIO[Any, AwsError, List[ValidNextStep]] =
      AwsError.unwrapOptionField("validNextSteps", validNextSteps)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetLocation
        : ZIO[Any, AwsError, zio.aws.ssm.model.TargetLocation.ReadOnly] =
      AwsError.unwrapOptionField("targetLocation", targetLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StepExecution
  ) extends zio.aws.ssm.model.StepExecution.ReadOnly {
    override val stepName: Option[String] =
      scala.Option(impl.stepName()).map(value => value: String)
    override val action: Option[AutomationActionName] = scala
      .Option(impl.action())
      .map(value => zio.aws.ssm.model.primitives.AutomationActionName(value))
    override val timeoutSeconds: Option[Long] =
      scala.Option(impl.timeoutSeconds()).map(value => value: Long)
    override val onFailure: Option[String] =
      scala.Option(impl.onFailure()).map(value => value: String)
    override val maxAttempts: Option[zio.aws.ssm.model.primitives.Integer] =
      scala
        .Option(impl.maxAttempts())
        .map(value => zio.aws.ssm.model.primitives.Integer(value))
    override val executionStartTime: Option[DateTime] = scala
      .Option(impl.executionStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executionEndTime: Option[DateTime] = scala
      .Option(impl.executionEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val stepStatus
        : Option[zio.aws.ssm.model.AutomationExecutionStatus] = scala
      .Option(impl.stepStatus())
      .map(value => zio.aws.ssm.model.AutomationExecutionStatus.wrap(value))
    override val responseCode: Option[String] =
      scala.Option(impl.responseCode()).map(value => value: String)
    override val inputs: Option[Map[String, String]] = scala
      .Option(impl.inputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val response: Option[String] =
      scala.Option(impl.response()).map(value => value: String)
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val failureDetails
        : Option[zio.aws.ssm.model.FailureDetails.ReadOnly] = scala
      .Option(impl.failureDetails())
      .map(value => zio.aws.ssm.model.FailureDetails.wrap(value))
    override val stepExecutionId: Option[String] =
      scala.Option(impl.stepExecutionId()).map(value => value: String)
    override val overriddenParameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.overriddenParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val isEnd: Option[Boolean] =
      scala.Option(impl.isEnd()).map(value => value: Boolean)
    override val nextStep: Option[String] =
      scala.Option(impl.nextStep()).map(value => value: String)
    override val isCritical: Option[Boolean] =
      scala.Option(impl.isCritical()).map(value => value: Boolean)
    override val validNextSteps: Option[List[ValidNextStep]] = scala
      .Option(impl.validNextSteps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ValidNextStep(item)
        }.toList
      )
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetLocation
        : Option[zio.aws.ssm.model.TargetLocation.ReadOnly] = scala
      .Option(impl.targetLocation())
      .map(value => zio.aws.ssm.model.TargetLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StepExecution
  ): zio.aws.ssm.model.StepExecution.ReadOnly = new Wrapper(impl)
}
