package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  DocumentVersion,
  DocumentName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentMetadataHistoryRequest(
    name: DocumentName,
    documentVersion: Option[DocumentVersion] = None,
    metadata: zio.aws.ssm.model.DocumentMetadataEnum,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest = {
    import ListDocumentMetadataHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .metadata(metadata.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly =
    zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.wrap(buildAwsValue())
}
object ListDocumentMetadataHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentMetadataHistoryRequest =
      zio.aws.ssm.model.ListDocumentMetadataHistoryRequest(
        name,
        documentVersion.map(value => value),
        metadata,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: DocumentName
    def documentVersion: Option[DocumentVersion]
    def metadata: zio.aws.ssm.model.DocumentMetadataEnum
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getMetadata: ZIO[Any, Nothing, zio.aws.ssm.model.DocumentMetadataEnum] =
      ZIO.succeed(metadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ) extends zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val metadata: zio.aws.ssm.model.DocumentMetadataEnum =
      zio.aws.ssm.model.DocumentMetadataEnum.wrap(impl.metadata())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest
  ): zio.aws.ssm.model.ListDocumentMetadataHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
