package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompliantSummary(
    compliantCount: Option[ComplianceSummaryCount] = None,
    severitySummary: Option[zio.aws.ssm.model.SeveritySummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CompliantSummary = {
    import CompliantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CompliantSummary
      .builder()
      .optionallyWith(
        compliantCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.compliantCount)
      .optionallyWith(severitySummary.map(value => value.buildAwsValue()))(
        _.severitySummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CompliantSummary.ReadOnly =
    zio.aws.ssm.model.CompliantSummary.wrap(buildAwsValue())
}
object CompliantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CompliantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CompliantSummary =
      zio.aws.ssm.model.CompliantSummary(
        compliantCount.map(value => value),
        severitySummary.map(value => value.asEditable)
      )
    def compliantCount: Option[ComplianceSummaryCount]
    def severitySummary: Option[zio.aws.ssm.model.SeveritySummary.ReadOnly]
    def getCompliantCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("compliantCount", compliantCount)
    def getSeveritySummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.SeveritySummary.ReadOnly] =
      AwsError.unwrapOptionField("severitySummary", severitySummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CompliantSummary
  ) extends zio.aws.ssm.model.CompliantSummary.ReadOnly {
    override val compliantCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.compliantCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val severitySummary
        : Option[zio.aws.ssm.model.SeveritySummary.ReadOnly] = scala
      .Option(impl.severitySummary())
      .map(value => zio.aws.ssm.model.SeveritySummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CompliantSummary
  ): zio.aws.ssm.model.CompliantSummary.ReadOnly = new Wrapper(impl)
}
