package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ResourceDataSyncDestinationDataSharingType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceDataSyncDestinationDataSharing(
    destinationDataSharingType: Option[
      ResourceDataSyncDestinationDataSharingType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing = {
    import ResourceDataSyncDestinationDataSharing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing
      .builder()
      .optionallyWith(
        destinationDataSharingType.map(value =>
          ResourceDataSyncDestinationDataSharingType.unwrap(
            value
          ): java.lang.String
        )
      )(_.destinationDataSharingType)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing
      .wrap(buildAwsValue())
}
object ResourceDataSyncDestinationDataSharing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing =
      zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing(
        destinationDataSharingType.map(value => value)
      )
    def destinationDataSharingType
        : Option[ResourceDataSyncDestinationDataSharingType]
    def getDestinationDataSharingType
        : ZIO[Any, AwsError, ResourceDataSyncDestinationDataSharingType] =
      AwsError.unwrapOptionField(
        "destinationDataSharingType",
        destinationDataSharingType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing
  ) extends zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly {
    override val destinationDataSharingType
        : Option[ResourceDataSyncDestinationDataSharingType] = scala
      .Option(impl.destinationDataSharingType())
      .map(value =>
        zio.aws.ssm.model.primitives
          .ResourceDataSyncDestinationDataSharingType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing
  ): zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly =
    new Wrapper(impl)
}
