package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PingStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.PingStatus
}
object PingStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PingStatus
  ): zio.aws.ssm.model.PingStatus = value match {
    case software.amazon.awssdk.services.ssm.model.PingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PingStatus.ONLINE =>
      val r = Online
      r
    case software.amazon.awssdk.services.ssm.model.PingStatus.CONNECTION_LOST =>
      val r = ConnectionLost
      r
    case software.amazon.awssdk.services.ssm.model.PingStatus.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PingStatus {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PingStatus =
      software.amazon.awssdk.services.ssm.model.PingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Online extends zio.aws.ssm.model.PingStatus {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PingStatus =
      software.amazon.awssdk.services.ssm.model.PingStatus.ONLINE
  }
  case object ConnectionLost extends zio.aws.ssm.model.PingStatus {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PingStatus =
      software.amazon.awssdk.services.ssm.model.PingStatus.CONNECTION_LOST
  }
  case object Inactive extends zio.aws.ssm.model.PingStatus {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PingStatus =
      software.amazon.awssdk.services.ssm.model.PingStatus.INACTIVE
  }
}
