package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAssociationVersionsResponse(
    associationVersions: Option[
      Iterable[zio.aws.ssm.model.AssociationVersionInfo]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse = {
    import ListAssociationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse
      .builder()
      .optionallyWith(
        associationVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly =
    zio.aws.ssm.model.ListAssociationVersionsResponse.wrap(buildAwsValue())
}
object ListAssociationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListAssociationVersionsResponse =
      zio.aws.ssm.model.ListAssociationVersionsResponse(
        associationVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associationVersions
        : Option[List[zio.aws.ssm.model.AssociationVersionInfo.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAssociationVersions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("associationVersions", associationVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse
  ) extends zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly {
    override val associationVersions
        : Option[List[zio.aws.ssm.model.AssociationVersionInfo.ReadOnly]] =
      scala
        .Option(impl.associationVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AssociationVersionInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse
  ): zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
