package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{InstanceId, DocumentARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAssociationStatusRequest(
    name: DocumentARN,
    instanceId: InstanceId,
    associationStatus: zio.aws.ssm.model.AssociationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest = {
    import UpdateAssociationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .associationStatus(associationStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateAssociationStatusRequest.ReadOnly =
    zio.aws.ssm.model.UpdateAssociationStatusRequest.wrap(buildAwsValue())
}
object UpdateAssociationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateAssociationStatusRequest =
      zio.aws.ssm.model.UpdateAssociationStatusRequest(
        name,
        instanceId,
        associationStatus.asEditable
      )
    def name: DocumentARN
    def instanceId: InstanceId
    def associationStatus: zio.aws.ssm.model.AssociationStatus.ReadOnly
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAssociationStatus
        : ZIO[Any, Nothing, zio.aws.ssm.model.AssociationStatus.ReadOnly] =
      ZIO.succeed(associationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest
  ) extends zio.aws.ssm.model.UpdateAssociationStatusRequest.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val associationStatus
        : zio.aws.ssm.model.AssociationStatus.ReadOnly =
      zio.aws.ssm.model.AssociationStatus.wrap(impl.associationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest
  ): zio.aws.ssm.model.UpdateAssociationStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
