package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AutomationExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartAutomationExecutionResponse(
    automationExecutionId: Option[AutomationExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse = {
    import StartAutomationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse
      .builder()
      .optionallyWith(
        automationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.automationExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly =
    zio.aws.ssm.model.StartAutomationExecutionResponse.wrap(buildAwsValue())
}
object StartAutomationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartAutomationExecutionResponse =
      zio.aws.ssm.model.StartAutomationExecutionResponse(
        automationExecutionId.map(value => value)
      )
    def automationExecutionId: Option[AutomationExecutionId]
    def getAutomationExecutionId: ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField("automationExecutionId", automationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse
  ) extends zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly {
    override val automationExecutionId: Option[AutomationExecutionId] = scala
      .Option(impl.automationExecutionId())
      .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse
  ): zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
