package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCommandsResponse(
    commands: Option[Iterable[zio.aws.ssm.model.Command]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListCommandsResponse = {
    import ListCommandsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListCommandsResponse
      .builder()
      .optionallyWith(
        commands.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commands)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListCommandsResponse.ReadOnly =
    zio.aws.ssm.model.ListCommandsResponse.wrap(buildAwsValue())
}
object ListCommandsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListCommandsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListCommandsResponse =
      zio.aws.ssm.model.ListCommandsResponse(
        commands.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def commands: Option[List[zio.aws.ssm.model.Command.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCommands
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Command.ReadOnly]] =
      AwsError.unwrapOptionField("commands", commands)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandsResponse
  ) extends zio.aws.ssm.model.ListCommandsResponse.ReadOnly {
    override val commands: Option[List[zio.aws.ssm.model.Command.ReadOnly]] =
      scala
        .Option(impl.commands())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Command.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandsResponse
  ): zio.aws.ssm.model.ListCommandsResponse.ReadOnly = new Wrapper(impl)
}
