package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InventoryDeletionLastStatusUpdateTime,
  InventoryDeletionLastStatusMessage,
  InventoryItemTypeName,
  UUID,
  InventoryDeletionStartTime
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class InventoryDeletionStatusItem(
    deletionId: Option[UUID] = None,
    typeName: Option[InventoryItemTypeName] = None,
    deletionStartTime: Option[InventoryDeletionStartTime] = None,
    lastStatus: Option[zio.aws.ssm.model.InventoryDeletionStatus] = None,
    lastStatusMessage: Option[InventoryDeletionLastStatusMessage] = None,
    deletionSummary: Option[zio.aws.ssm.model.InventoryDeletionSummary] = None,
    lastStatusUpdateTime: Option[InventoryDeletionLastStatusUpdateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem = {
    import InventoryDeletionStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
      .builder()
      .optionallyWith(
        deletionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.deletionId)
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(
        deletionStartTime.map(value =>
          InventoryDeletionStartTime.unwrap(value): Instant
        )
      )(_.deletionStartTime)
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(
        lastStatusMessage.map(value =>
          InventoryDeletionLastStatusMessage.unwrap(value): java.lang.String
        )
      )(_.lastStatusMessage)
      .optionallyWith(deletionSummary.map(value => value.buildAwsValue()))(
        _.deletionSummary
      )
      .optionallyWith(
        lastStatusUpdateTime.map(value =>
          InventoryDeletionLastStatusUpdateTime.unwrap(value): Instant
        )
      )(_.lastStatusUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly =
    zio.aws.ssm.model.InventoryDeletionStatusItem.wrap(buildAwsValue())
}
object InventoryDeletionStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryDeletionStatusItem =
      zio.aws.ssm.model.InventoryDeletionStatusItem(
        deletionId.map(value => value),
        typeName.map(value => value),
        deletionStartTime.map(value => value),
        lastStatus.map(value => value),
        lastStatusMessage.map(value => value),
        deletionSummary.map(value => value.asEditable),
        lastStatusUpdateTime.map(value => value)
      )
    def deletionId: Option[UUID]
    def typeName: Option[InventoryItemTypeName]
    def deletionStartTime: Option[InventoryDeletionStartTime]
    def lastStatus: Option[zio.aws.ssm.model.InventoryDeletionStatus]
    def lastStatusMessage: Option[InventoryDeletionLastStatusMessage]
    def deletionSummary
        : Option[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly]
    def lastStatusUpdateTime: Option[InventoryDeletionLastStatusUpdateTime]
    def getDeletionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("deletionId", deletionId)
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDeletionStartTime: ZIO[Any, AwsError, InventoryDeletionStartTime] =
      AwsError.unwrapOptionField("deletionStartTime", deletionStartTime)
    def getLastStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.InventoryDeletionStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastStatusMessage
        : ZIO[Any, AwsError, InventoryDeletionLastStatusMessage] =
      AwsError.unwrapOptionField("lastStatusMessage", lastStatusMessage)
    def getDeletionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("deletionSummary", deletionSummary)
    def getLastStatusUpdateTime
        : ZIO[Any, AwsError, InventoryDeletionLastStatusUpdateTime] =
      AwsError.unwrapOptionField("lastStatusUpdateTime", lastStatusUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ) extends zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly {
    override val deletionId: Option[UUID] = scala
      .Option(impl.deletionId())
      .map(value => zio.aws.ssm.model.primitives.UUID(value))
    override val typeName: Option[InventoryItemTypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.ssm.model.primitives.InventoryItemTypeName(value))
    override val deletionStartTime: Option[InventoryDeletionStartTime] = scala
      .Option(impl.deletionStartTime())
      .map(value =>
        zio.aws.ssm.model.primitives.InventoryDeletionStartTime(value)
      )
    override val lastStatus: Option[zio.aws.ssm.model.InventoryDeletionStatus] =
      scala
        .Option(impl.lastStatus())
        .map(value => zio.aws.ssm.model.InventoryDeletionStatus.wrap(value))
    override val lastStatusMessage: Option[InventoryDeletionLastStatusMessage] =
      scala
        .Option(impl.lastStatusMessage())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryDeletionLastStatusMessage(value)
        )
    override val deletionSummary
        : Option[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly] = scala
      .Option(impl.deletionSummary())
      .map(value => zio.aws.ssm.model.InventoryDeletionSummary.wrap(value))
    override val lastStatusUpdateTime
        : Option[InventoryDeletionLastStatusUpdateTime] = scala
      .Option(impl.lastStatusUpdateTime())
      .map(value =>
        zio.aws.ssm.model.primitives
          .InventoryDeletionLastStatusUpdateTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem
  ): zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly = new Wrapper(impl)
}
