package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemPriority,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters.*
final case class UpdateOpsItemRequest(
    description: Option[OpsItemDescription] = None,
    operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = None,
    operationalDataToDelete: Option[Iterable[String]] = None,
    notifications: Option[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      None,
    priority: Option[OpsItemPriority] = None,
    relatedOpsItems: Option[Iterable[zio.aws.ssm.model.RelatedOpsItem]] = None,
    status: Option[zio.aws.ssm.model.OpsItemStatus] = None,
    opsItemId: OpsItemId,
    title: Option[OpsItemTitle] = None,
    category: Option[OpsItemCategory] = None,
    severity: Option[OpsItemSeverity] = None,
    actualStartTime: Option[DateTime] = None,
    actualEndTime: Option[DateTime] = None,
    plannedStartTime: Option[DateTime] = None,
    plannedEndTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest = {
    import UpdateOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          OpsItemDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        operationalDataToDelete.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.operationalDataToDelete)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.UpdateOpsItemRequest.wrap(buildAwsValue())
}
object UpdateOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateOpsItemRequest =
      zio.aws.ssm.model.UpdateOpsItemRequest(
        description.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        operationalDataToDelete.map(value => value),
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        priority.map(value => value),
        relatedOpsItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        opsItemId,
        title.map(value => value),
        category.map(value => value),
        severity.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value)
      )
    def description: Option[OpsItemDescription]
    def operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def operationalDataToDelete: Option[List[String]]
    def notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Option[OpsItemPriority]
    def relatedOpsItems: Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def status: Option[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: OpsItemId
    def title: Option[OpsItemTitle]
    def category: Option[OpsItemCategory]
    def severity: Option[OpsItemSeverity]
    def actualStartTime: Option[DateTime]
    def actualEndTime: Option[DateTime]
    def plannedStartTime: Option[DateTime]
    def plannedEndTime: Option[DateTime]
    def getDescription: ZIO[Any, AwsError, OpsItemDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getOperationalDataToDelete: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("operationalDataToDelete", operationalDataToDelete)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ) extends zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly {
    override val description: Option[OpsItemDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.OpsItemDescription(value))
    override val operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = scala
      .Option(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val operationalDataToDelete: Option[List[String]] = scala
      .Option(impl.operationalDataToDelete())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] = scala
      .Option(impl.notifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemNotification.wrap(item)
        }.toList
      )
    override val priority: Option[OpsItemPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] = scala
      .Option(impl.relatedOpsItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.RelatedOpsItem.wrap(item)
        }.toList
      )
    override val status: Option[zio.aws.ssm.model.OpsItemStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
    override val title: Option[OpsItemTitle] = scala
      .Option(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val category: Option[OpsItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Option[OpsItemSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Option[DateTime] = scala
      .Option(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Option[DateTime] = scala
      .Option(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Option[DateTime] = scala
      .Option(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Option[DateTime] = scala
      .Option(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest
  ): zio.aws.ssm.model.UpdateOpsItemRequest.ReadOnly = new Wrapper(impl)
}
