package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.ssm.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.SourceType
  ): zio.aws.ssm.model.SourceType = value match {
    case software.amazon.awssdk.services.ssm.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.SourceType.AWS_EC2_INSTANCE =>
      val r = `AWS::EC2::Instance`
      r
    case software.amazon.awssdk.services.ssm.model.SourceType.AWS_IOT_THING =>
      val r = `AWS::IoT::Thing`
      r
    case software.amazon.awssdk.services.ssm.model.SourceType.AWS_SSM_MANAGED_INSTANCE =>
      val r = `AWS::SSM::ManagedInstance`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SourceType =
      software.amazon.awssdk.services.ssm.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::EC2::Instance` extends zio.aws.ssm.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SourceType =
      software.amazon.awssdk.services.ssm.model.SourceType.AWS_EC2_INSTANCE
  }
  case object `AWS::IoT::Thing` extends zio.aws.ssm.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SourceType =
      software.amazon.awssdk.services.ssm.model.SourceType.AWS_IOT_THING
  }
  case object `AWS::SSM::ManagedInstance` extends zio.aws.ssm.model.SourceType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SourceType =
      software.amazon.awssdk.services.ssm.model.SourceType.AWS_SSM_MANAGED_INSTANCE
  }
}
