package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeInstancePatchesResponse(
    patches: Option[Iterable[zio.aws.ssm.model.PatchComplianceData]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse = {
    import DescribeInstancePatchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse
      .builder()
      .optionallyWith(
        patches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patches)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchesResponse.wrap(buildAwsValue())
}
object DescribeInstancePatchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePatchesResponse =
      zio.aws.ssm.model.DescribeInstancePatchesResponse(
        patches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def patches: Option[List[zio.aws.ssm.model.PatchComplianceData.ReadOnly]]
    def nextToken: Option[NextToken]
    def getPatches: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchComplianceData.ReadOnly
    ]] = AwsError.unwrapOptionField("patches", patches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse
  ) extends zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly {
    override val patches
        : Option[List[zio.aws.ssm.model.PatchComplianceData.ReadOnly]] = scala
      .Option(impl.patches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.PatchComplianceData.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse
  ): zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly = new Wrapper(
    impl
  )
}
