package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ChangeRequestName,
  TargetMapValue,
  AutomationParameterValue,
  AutomationExecutionId,
  DocumentName,
  TargetMapKey,
  DocumentVersion,
  AutomationParameterKey,
  DateTime,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AutomationExecutionMetadata(
    automationExecutionId: Option[AutomationExecutionId] = None,
    documentName: Option[DocumentName] = None,
    documentVersion: Option[DocumentVersion] = None,
    automationExecutionStatus: Option[
      zio.aws.ssm.model.AutomationExecutionStatus
    ] = None,
    executionStartTime: Option[DateTime] = None,
    executionEndTime: Option[DateTime] = None,
    executedBy: Option[String] = None,
    logFile: Option[String] = None,
    outputs: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    mode: Option[zio.aws.ssm.model.ExecutionMode] = None,
    parentAutomationExecutionId: Option[AutomationExecutionId] = None,
    currentStepName: Option[String] = None,
    currentAction: Option[String] = None,
    failureMessage: Option[String] = None,
    targetParameterName: Option[AutomationParameterKey] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    targetMaps: Option[Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]] =
      None,
    resolvedTargets: Option[zio.aws.ssm.model.ResolvedTargets] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    target: Option[String] = None,
    automationType: Option[zio.aws.ssm.model.AutomationType] = None,
    automationSubtype: Option[zio.aws.ssm.model.AutomationSubtype] = None,
    scheduledTime: Option[DateTime] = None,
    runbooks: Option[Iterable[zio.aws.ssm.model.Runbook]] = None,
    opsItemId: Option[String] = None,
    associationId: Option[String] = None,
    changeRequestName: Option[ChangeRequestName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata = {
    import AutomationExecutionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata
      .builder()
      .optionallyWith(
        automationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.automationExecutionId)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(automationExecutionStatus.map(value => value.unwrap))(
        _.automationExecutionStatus
      )
      .optionallyWith(
        executionStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionStartTime)
      .optionallyWith(
        executionEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionEndTime)
      .optionallyWith(executedBy.map(value => value: java.lang.String))(
        _.executedBy
      )
      .optionallyWith(logFile.map(value => value: java.lang.String))(_.logFile)
      .optionallyWith(
        outputs.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.outputs)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        parentAutomationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.parentAutomationExecutionId)
      .optionallyWith(currentStepName.map(value => value: java.lang.String))(
        _.currentStepName
      )
      .optionallyWith(currentAction.map(value => value: java.lang.String))(
        _.currentAction
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(resolvedTargets.map(value => value.buildAwsValue()))(
        _.resolvedTargets
      )
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(target.map(value => value: java.lang.String))(_.target)
      .optionallyWith(automationType.map(value => value.unwrap))(
        _.automationType
      )
      .optionallyWith(automationSubtype.map(value => value.unwrap))(
        _.automationSubtype
      )
      .optionallyWith(
        scheduledTime.map(value => DateTime.unwrap(value): Instant)
      )(_.scheduledTime)
      .optionallyWith(
        runbooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runbooks)
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(
        changeRequestName.map(value =>
          ChangeRequestName.unwrap(value): java.lang.String
        )
      )(_.changeRequestName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly =
    zio.aws.ssm.model.AutomationExecutionMetadata.wrap(buildAwsValue())
}
object AutomationExecutionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AutomationExecutionMetadata =
      zio.aws.ssm.model.AutomationExecutionMetadata(
        automationExecutionId.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        automationExecutionStatus.map(value => value),
        executionStartTime.map(value => value),
        executionEndTime.map(value => value),
        executedBy.map(value => value),
        logFile.map(value => value),
        outputs.map(value => value),
        mode.map(value => value),
        parentAutomationExecutionId.map(value => value),
        currentStepName.map(value => value),
        currentAction.map(value => value),
        failureMessage.map(value => value),
        targetParameterName.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetMaps.map(value => value),
        resolvedTargets.map(value => value.asEditable),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        target.map(value => value),
        automationType.map(value => value),
        automationSubtype.map(value => value),
        scheduledTime.map(value => value),
        runbooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        opsItemId.map(value => value),
        associationId.map(value => value),
        changeRequestName.map(value => value)
      )
    def automationExecutionId: Option[AutomationExecutionId]
    def documentName: Option[DocumentName]
    def documentVersion: Option[DocumentVersion]
    def automationExecutionStatus
        : Option[zio.aws.ssm.model.AutomationExecutionStatus]
    def executionStartTime: Option[DateTime]
    def executionEndTime: Option[DateTime]
    def executedBy: Option[String]
    def logFile: Option[String]
    def outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def mode: Option[zio.aws.ssm.model.ExecutionMode]
    def parentAutomationExecutionId: Option[AutomationExecutionId]
    def currentStepName: Option[String]
    def currentAction: Option[String]
    def failureMessage: Option[String]
    def targetParameterName: Option[AutomationParameterKey]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Option[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def resolvedTargets: Option[zio.aws.ssm.model.ResolvedTargets.ReadOnly]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def target: Option[String]
    def automationType: Option[zio.aws.ssm.model.AutomationType]
    def automationSubtype: Option[zio.aws.ssm.model.AutomationSubtype]
    def scheduledTime: Option[DateTime]
    def runbooks: Option[List[zio.aws.ssm.model.Runbook.ReadOnly]]
    def opsItemId: Option[String]
    def associationId: Option[String]
    def changeRequestName: Option[ChangeRequestName]
    def getAutomationExecutionId: ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField("automationExecutionId", automationExecutionId)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getAutomationExecutionStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecutionStatus] =
      AwsError.unwrapOptionField(
        "automationExecutionStatus",
        automationExecutionStatus
      )
    def getExecutionStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionStartTime", executionStartTime)
    def getExecutionEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionEndTime", executionEndTime)
    def getExecutedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executedBy", executedBy)
    def getLogFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFile", logFile)
    def getOutputs: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("outputs", outputs)
    def getMode: ZIO[Any, AwsError, zio.aws.ssm.model.ExecutionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getParentAutomationExecutionId
        : ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField(
        "parentAutomationExecutionId",
        parentAutomationExecutionId
      )
    def getCurrentStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentStepName", currentStepName)
    def getCurrentAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentAction", currentAction)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getResolvedTargets
        : ZIO[Any, AwsError, zio.aws.ssm.model.ResolvedTargets.ReadOnly] =
      AwsError.unwrapOptionField("resolvedTargets", resolvedTargets)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("target", target)
    def getAutomationType
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationType] =
      AwsError.unwrapOptionField("automationType", automationType)
    def getAutomationSubtype
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationSubtype] =
      AwsError.unwrapOptionField("automationSubtype", automationSubtype)
    def getScheduledTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
    def getRunbooks
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      AwsError.unwrapOptionField("runbooks", runbooks)
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getChangeRequestName: ZIO[Any, AwsError, ChangeRequestName] =
      AwsError.unwrapOptionField("changeRequestName", changeRequestName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata
  ) extends zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly {
    override val automationExecutionId: Option[AutomationExecutionId] = scala
      .Option(impl.automationExecutionId())
      .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val documentName: Option[DocumentName] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val automationExecutionStatus
        : Option[zio.aws.ssm.model.AutomationExecutionStatus] = scala
      .Option(impl.automationExecutionStatus())
      .map(value => zio.aws.ssm.model.AutomationExecutionStatus.wrap(value))
    override val executionStartTime: Option[DateTime] = scala
      .Option(impl.executionStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executionEndTime: Option[DateTime] = scala
      .Option(impl.executionEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executedBy: Option[String] =
      scala.Option(impl.executedBy()).map(value => value: String)
    override val logFile: Option[String] =
      scala.Option(impl.logFile()).map(value => value: String)
    override val outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val mode: Option[zio.aws.ssm.model.ExecutionMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.ssm.model.ExecutionMode.wrap(value))
    override val parentAutomationExecutionId: Option[AutomationExecutionId] =
      scala
        .Option(impl.parentAutomationExecutionId())
        .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val currentStepName: Option[String] =
      scala.Option(impl.currentStepName()).map(value => value: String)
    override val currentAction: Option[String] =
      scala.Option(impl.currentAction()).map(value => value: String)
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val targetParameterName: Option[AutomationParameterKey] = scala
      .Option(impl.targetParameterName())
      .map(value => zio.aws.ssm.model.primitives.AutomationParameterKey(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Option[List[Map[TargetMapKey, List[TargetMapValue]]]] = scala
      .Option(impl.targetMaps())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .TargetMapKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.TargetMapValue(item)
              }.toList
            })
            .toMap
        }.toList
      )
    override val resolvedTargets
        : Option[zio.aws.ssm.model.ResolvedTargets.ReadOnly] = scala
      .Option(impl.resolvedTargets())
      .map(value => zio.aws.ssm.model.ResolvedTargets.wrap(value))
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val target: Option[String] =
      scala.Option(impl.target()).map(value => value: String)
    override val automationType: Option[zio.aws.ssm.model.AutomationType] =
      scala
        .Option(impl.automationType())
        .map(value => zio.aws.ssm.model.AutomationType.wrap(value))
    override val automationSubtype
        : Option[zio.aws.ssm.model.AutomationSubtype] = scala
      .Option(impl.automationSubtype())
      .map(value => zio.aws.ssm.model.AutomationSubtype.wrap(value))
    override val scheduledTime: Option[DateTime] = scala
      .Option(impl.scheduledTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val runbooks: Option[List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      scala
        .Option(impl.runbooks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Runbook.wrap(item)
          }.toList
        )
    override val opsItemId: Option[String] =
      scala.Option(impl.opsItemId()).map(value => value: String)
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val changeRequestName: Option[ChangeRequestName] = scala
      .Option(impl.changeRequestName())
      .map(value => zio.aws.ssm.model.primitives.ChangeRequestName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata
  ): zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly = new Wrapper(impl)
}
