package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DateTime,
  ServiceSettingValue,
  ServiceSettingId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceSetting(
    settingId: Option[ServiceSettingId] = None,
    settingValue: Option[ServiceSettingValue] = None,
    lastModifiedDate: Option[DateTime] = None,
    lastModifiedUser: Option[String] = None,
    arn: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ServiceSetting = {
    import ServiceSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ServiceSetting
      .builder()
      .optionallyWith(
        settingId.map(value => ServiceSettingId.unwrap(value): java.lang.String)
      )(_.settingId)
      .optionallyWith(
        settingValue.map(value =>
          ServiceSettingValue.unwrap(value): java.lang.String
        )
      )(_.settingValue)
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedUser.map(value => value: java.lang.String))(
        _.lastModifiedUser
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ServiceSetting.ReadOnly =
    zio.aws.ssm.model.ServiceSetting.wrap(buildAwsValue())
}
object ServiceSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ServiceSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ServiceSetting =
      zio.aws.ssm.model.ServiceSetting(
        settingId.map(value => value),
        settingValue.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedUser.map(value => value),
        arn.map(value => value),
        status.map(value => value)
      )
    def settingId: Option[ServiceSettingId]
    def settingValue: Option[ServiceSettingValue]
    def lastModifiedDate: Option[DateTime]
    def lastModifiedUser: Option[String]
    def arn: Option[String]
    def status: Option[String]
    def getSettingId: ZIO[Any, AwsError, ServiceSettingId] =
      AwsError.unwrapOptionField("settingId", settingId)
    def getSettingValue: ZIO[Any, AwsError, ServiceSettingValue] =
      AwsError.unwrapOptionField("settingValue", settingValue)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ServiceSetting
  ) extends zio.aws.ssm.model.ServiceSetting.ReadOnly {
    override val settingId: Option[ServiceSettingId] = scala
      .Option(impl.settingId())
      .map(value => zio.aws.ssm.model.primitives.ServiceSettingId(value))
    override val settingValue: Option[ServiceSettingValue] = scala
      .Option(impl.settingValue())
      .map(value => zio.aws.ssm.model.primitives.ServiceSettingValue(value))
    override val lastModifiedDate: Option[DateTime] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedUser: Option[String] =
      scala.Option(impl.lastModifiedUser()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ServiceSetting
  ): zio.aws.ssm.model.ServiceSetting.ReadOnly = new Wrapper(impl)
}
