package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceInformationResponse(
    instanceInformationList: Option[
      Iterable[zio.aws.ssm.model.InstanceInformation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse = {
    import DescribeInstanceInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse
      .builder()
      .optionallyWith(
        instanceInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceInformationList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInstanceInformationResponse.wrap(buildAwsValue())
}
object DescribeInstanceInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstanceInformationResponse =
      zio.aws.ssm.model.DescribeInstanceInformationResponse(
        instanceInformationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceInformationList
        : Option[List[zio.aws.ssm.model.InstanceInformation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getInstanceInformationList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceInformationList",
      instanceInformationList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse
  ) extends zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly {
    override val instanceInformationList
        : Option[List[zio.aws.ssm.model.InstanceInformation.ReadOnly]] = scala
      .Option(impl.instanceInformationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstanceInformation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse
  ): zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly =
    new Wrapper(impl)
}
