package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResultsEC2Compatible}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceInformationRequest(
    instanceInformationFilterList: Option[
      Iterable[zio.aws.ssm.model.InstanceInformationFilter]
    ] = None,
    filters: Option[
      Iterable[zio.aws.ssm.model.InstanceInformationStringFilter]
    ] = None,
    maxResults: Option[MaxResultsEC2Compatible] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest = {
    import DescribeInstanceInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
      .builder()
      .optionallyWith(
        instanceInformationFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceInformationFilterList)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResultsEC2Compatible.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstanceInformationRequest.wrap(buildAwsValue())
}
object DescribeInstanceInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstanceInformationRequest =
      zio.aws.ssm.model.DescribeInstanceInformationRequest(
        instanceInformationFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceInformationFilterList
        : Option[List[zio.aws.ssm.model.InstanceInformationFilter.ReadOnly]]
    def filters: Option[
      List[zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly]
    ]
    def maxResults: Option[MaxResultsEC2Compatible]
    def nextToken: Option[NextToken]
    def getInstanceInformationFilterList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceInformationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceInformationFilterList",
      instanceInformationFilterList
    )
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsEC2Compatible] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ) extends zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly {
    override val instanceInformationFilterList
        : Option[List[zio.aws.ssm.model.InstanceInformationFilter.ReadOnly]] =
      scala
        .Option(impl.instanceInformationFilterList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstanceInformationFilter.wrap(item)
          }.toList
        )
    override val filters: Option[
      List[zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstanceInformationStringFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResultsEC2Compatible] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResultsEC2Compatible(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest
  ): zio.aws.ssm.model.DescribeInstanceInformationRequest.ReadOnly =
    new Wrapper(impl)
}
