package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentResponse(
    document: Option[zio.aws.ssm.model.DocumentDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse = {
    import DescribeDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse
      .builder()
      .optionallyWith(document.map(value => value.buildAwsValue()))(_.document)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly =
    zio.aws.ssm.model.DescribeDocumentResponse.wrap(buildAwsValue())
}
object DescribeDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeDocumentResponse =
      zio.aws.ssm.model
        .DescribeDocumentResponse(document.map(value => value.asEditable))
    def document: Option[zio.aws.ssm.model.DocumentDescription.ReadOnly]
    def getDocument
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentDescription.ReadOnly] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse
  ) extends zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly {
    override val document
        : Option[zio.aws.ssm.model.DocumentDescription.ReadOnly] = scala
      .Option(impl.document())
      .map(value => zio.aws.ssm.model.DocumentDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse
  ): zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly = new Wrapper(impl)
}
