package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationId,
  ApplyOnlyAtCronInterval,
  ParameterName,
  ParameterValue,
  DocumentARN,
  ScheduleExpression,
  AssociationName,
  DocumentVersion,
  AssociationVersion,
  CalendarNameOrARN,
  AutomationTargetParameterName,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAssociationRequest(
    associationId: AssociationId,
    parameters: Option[Map[ParameterName, Iterable[ParameterValue]]] = None,
    documentVersion: Option[DocumentVersion] = None,
    scheduleExpression: Option[ScheduleExpression] = None,
    outputLocation: Option[
      zio.aws.ssm.model.InstanceAssociationOutputLocation
    ] = None,
    name: Option[DocumentARN] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    associationName: Option[AssociationName] = None,
    associationVersion: Option[AssociationVersion] = None,
    automationTargetParameterName: Option[AutomationTargetParameterName] = None,
    maxErrors: Option[MaxErrors] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    complianceSeverity: Option[
      zio.aws.ssm.model.AssociationComplianceSeverity
    ] = None,
    syncCompliance: Option[zio.aws.ssm.model.AssociationSyncCompliance] = None,
    applyOnlyAtCronInterval: Option[ApplyOnlyAtCronInterval] = None,
    calendarNames: Option[Iterable[CalendarNameOrARN]] = None,
    targetLocations: Option[Iterable[zio.aws.ssm.model.TargetLocation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest = {
    import UpdateAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
      .builder()
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        automationTargetParameterName.map(value =>
          AutomationTargetParameterName.unwrap(value): java.lang.String
        )
      )(_.automationTargetParameterName)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(complianceSeverity.map(value => value.unwrap))(
        _.complianceSeverity
      )
      .optionallyWith(syncCompliance.map(value => value.unwrap))(
        _.syncCompliance
      )
      .optionallyWith(
        applyOnlyAtCronInterval.map(value =>
          ApplyOnlyAtCronInterval.unwrap(value): java.lang.Boolean
        )
      )(_.applyOnlyAtCronInterval)
      .optionallyWith(
        calendarNames.map(value =>
          value.map { item =>
            CalendarNameOrARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.calendarNames)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly =
    zio.aws.ssm.model.UpdateAssociationRequest.wrap(buildAwsValue())
}
object UpdateAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateAssociationRequest =
      zio.aws.ssm.model.UpdateAssociationRequest(
        associationId,
        parameters.map(value => value),
        documentVersion.map(value => value),
        scheduleExpression.map(value => value),
        outputLocation.map(value => value.asEditable),
        name.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        associationName.map(value => value),
        associationVersion.map(value => value),
        automationTargetParameterName.map(value => value),
        maxErrors.map(value => value),
        maxConcurrency.map(value => value),
        complianceSeverity.map(value => value),
        syncCompliance.map(value => value),
        applyOnlyAtCronInterval.map(value => value),
        calendarNames.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associationId: AssociationId
    def parameters: Option[Map[ParameterName, List[ParameterValue]]]
    def documentVersion: Option[DocumentVersion]
    def scheduleExpression: Option[ScheduleExpression]
    def outputLocation
        : Option[zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly]
    def name: Option[DocumentARN]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def associationName: Option[AssociationName]
    def associationVersion: Option[AssociationVersion]
    def automationTargetParameterName: Option[AutomationTargetParameterName]
    def maxErrors: Option[MaxErrors]
    def maxConcurrency: Option[MaxConcurrency]
    def complianceSeverity
        : Option[zio.aws.ssm.model.AssociationComplianceSeverity]
    def syncCompliance: Option[zio.aws.ssm.model.AssociationSyncCompliance]
    def applyOnlyAtCronInterval: Option[ApplyOnlyAtCronInterval]
    def calendarNames: Option[List[CalendarNameOrARN]]
    def targetLocations: Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getOutputLocation: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getAutomationTargetParameterName
        : ZIO[Any, AwsError, AutomationTargetParameterName] =
      AwsError.unwrapOptionField(
        "automationTargetParameterName",
        automationTargetParameterName
      )
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getComplianceSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationComplianceSeverity] =
      AwsError.unwrapOptionField("complianceSeverity", complianceSeverity)
    def getSyncCompliance
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationSyncCompliance] =
      AwsError.unwrapOptionField("syncCompliance", syncCompliance)
    def getApplyOnlyAtCronInterval
        : ZIO[Any, AwsError, ApplyOnlyAtCronInterval] = AwsError
      .unwrapOptionField("applyOnlyAtCronInterval", applyOnlyAtCronInterval)
    def getCalendarNames: ZIO[Any, AwsError, List[CalendarNameOrARN]] =
      AwsError.unwrapOptionField("calendarNames", calendarNames)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ) extends zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly {
    override val associationId: AssociationId =
      zio.aws.ssm.model.primitives.AssociationId(impl.associationId())
    override val parameters: Option[Map[ParameterName, List[ParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val scheduleExpression: Option[ScheduleExpression] = scala
      .Option(impl.scheduleExpression())
      .map(value => zio.aws.ssm.model.primitives.ScheduleExpression(value))
    override val outputLocation
        : Option[zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly] =
      scala
        .Option(impl.outputLocation())
        .map(value =>
          zio.aws.ssm.model.InstanceAssociationOutputLocation.wrap(value)
        )
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val associationName: Option[AssociationName] = scala
      .Option(impl.associationName())
      .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val automationTargetParameterName
        : Option[AutomationTargetParameterName] = scala
      .Option(impl.automationTargetParameterName())
      .map(value =>
        zio.aws.ssm.model.primitives.AutomationTargetParameterName(value)
      )
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val complianceSeverity
        : Option[zio.aws.ssm.model.AssociationComplianceSeverity] = scala
      .Option(impl.complianceSeverity())
      .map(value => zio.aws.ssm.model.AssociationComplianceSeverity.wrap(value))
    override val syncCompliance
        : Option[zio.aws.ssm.model.AssociationSyncCompliance] = scala
      .Option(impl.syncCompliance())
      .map(value => zio.aws.ssm.model.AssociationSyncCompliance.wrap(value))
    override val applyOnlyAtCronInterval: Option[ApplyOnlyAtCronInterval] =
      scala
        .Option(impl.applyOnlyAtCronInterval())
        .map(value =>
          zio.aws.ssm.model.primitives.ApplyOnlyAtCronInterval(value)
        )
    override val calendarNames: Option[List[CalendarNameOrARN]] = scala
      .Option(impl.calendarNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.CalendarNameOrARN(item)
        }.toList
      )
    override val targetLocations
        : Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] = scala
      .Option(impl.targetLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.TargetLocation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ): zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly = new Wrapper(impl)
}
