package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  OpsAggregatorValue,
  OpsAggregatorValueKey,
  OpsAggregatorType,
  OpsDataAttributeName,
  OpsDataTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpsAggregator(
    aggregatorType: Option[OpsAggregatorType] = None,
    typeName: Option[OpsDataTypeName] = None,
    attributeName: Option[OpsDataAttributeName] = None,
    values: Option[Map[OpsAggregatorValueKey, OpsAggregatorValue]] = None,
    filters: Option[Iterable[zio.aws.ssm.model.OpsFilter]] = None,
    aggregators: Option[Iterable[zio.aws.ssm.model.OpsAggregator]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsAggregator = {
    import OpsAggregator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsAggregator
      .builder()
      .optionallyWith(
        aggregatorType.map(value =>
          OpsAggregatorType.unwrap(value): java.lang.String
        )
      )(_.aggregatorType)
      .optionallyWith(
        typeName.map(value => OpsDataTypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        attributeName.map(value =>
          OpsDataAttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        values.map(value =>
          value
            .map({ case (key, value) =>
              (OpsAggregatorValueKey.unwrap(
                key
              ): java.lang.String) -> (OpsAggregatorValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.values)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsAggregator.ReadOnly =
    zio.aws.ssm.model.OpsAggregator.wrap(buildAwsValue())
}
object OpsAggregator {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsAggregator] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsAggregator =
      zio.aws.ssm.model.OpsAggregator(
        aggregatorType.map(value => value),
        typeName.map(value => value),
        attributeName.map(value => value),
        values.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def aggregatorType: Option[OpsAggregatorType]
    def typeName: Option[OpsDataTypeName]
    def attributeName: Option[OpsDataAttributeName]
    def values: Option[Map[OpsAggregatorValueKey, OpsAggregatorValue]]
    def filters: Option[List[zio.aws.ssm.model.OpsFilter.ReadOnly]]
    def aggregators: Option[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]]
    def getAggregatorType: ZIO[Any, AwsError, OpsAggregatorType] =
      AwsError.unwrapOptionField("aggregatorType", aggregatorType)
    def getTypeName: ZIO[Any, AwsError, OpsDataTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getAttributeName: ZIO[Any, AwsError, OpsDataAttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getValues
        : ZIO[Any, AwsError, Map[OpsAggregatorValueKey, OpsAggregatorValue]] =
      AwsError.unwrapOptionField("values", values)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      AwsError.unwrapOptionField("aggregators", aggregators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsAggregator
  ) extends zio.aws.ssm.model.OpsAggregator.ReadOnly {
    override val aggregatorType: Option[OpsAggregatorType] = scala
      .Option(impl.aggregatorType())
      .map(value => zio.aws.ssm.model.primitives.OpsAggregatorType(value))
    override val typeName: Option[OpsDataTypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.ssm.model.primitives.OpsDataTypeName(value))
    override val attributeName: Option[OpsDataAttributeName] = scala
      .Option(impl.attributeName())
      .map(value => zio.aws.ssm.model.primitives.OpsDataAttributeName(value))
    override val values
        : Option[Map[OpsAggregatorValueKey, OpsAggregatorValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsAggregatorValueKey(
              key
            ) -> zio.aws.ssm.model.primitives.OpsAggregatorValue(value)
          })
          .toMap
      )
    override val filters: Option[List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsFilter.wrap(item)
          }.toList
        )
    override val aggregators
        : Option[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] = scala
      .Option(impl.aggregators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsAggregator.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsAggregator
  ): zio.aws.ssm.model.OpsAggregator.ReadOnly = new Wrapper(impl)
}
