package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MaintenanceWindowName, MaintenanceWindowId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowIdentityForTarget(
    windowId: Option[MaintenanceWindowId] = None,
    name: Option[MaintenanceWindowName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget = {
    import MaintenanceWindowIdentityForTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.wrap(buildAwsValue())
}
object MaintenanceWindowIdentityForTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowIdentityForTarget =
      zio.aws.ssm.model.MaintenanceWindowIdentityForTarget(
        windowId.map(value => value),
        name.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def name: Option[MaintenanceWindowName]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget
  ) extends zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget
  ): zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly =
    new Wrapper(impl)
}
