package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  AutomationParameterKey,
  DocumentVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowAutomationParameters(
    documentVersion: Option[DocumentVersion] = None,
    parameters: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters = {
    import MaintenanceWindowAutomationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters
      .builder()
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey
                .unwrap(key): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowAutomationParameters
      .wrap(buildAwsValue())
}
object MaintenanceWindowAutomationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowAutomationParameters =
      zio.aws.ssm.model.MaintenanceWindowAutomationParameters(
        documentVersion.map(value => value),
        parameters.map(value => value)
      )
    def documentVersion: Option[DocumentVersion]
    def parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly {
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters
  ): zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly =
    new Wrapper(impl)
}
