package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{RemainingCount, TotalCount}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InventoryDeletionSummary(
    totalCount: Option[TotalCount] = None,
    remainingCount: Option[RemainingCount] = None,
    summaryItems: Option[
      Iterable[zio.aws.ssm.model.InventoryDeletionSummaryItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary = {
    import InventoryDeletionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary
      .builder()
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .optionallyWith(
        remainingCount.map(value => RemainingCount.unwrap(value): Integer)
      )(_.remainingCount)
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly =
    zio.aws.ssm.model.InventoryDeletionSummary.wrap(buildAwsValue())
}
object InventoryDeletionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryDeletionSummary =
      zio.aws.ssm.model.InventoryDeletionSummary(
        totalCount.map(value => value),
        remainingCount.map(value => value),
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalCount: Option[TotalCount]
    def remainingCount: Option[RemainingCount]
    def summaryItems
        : Option[List[zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly]]
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getRemainingCount: ZIO[Any, AwsError, RemainingCount] =
      AwsError.unwrapOptionField("remainingCount", remainingCount)
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary
  ) extends zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly {
    override val totalCount: Option[TotalCount] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.ssm.model.primitives.TotalCount(value))
    override val remainingCount: Option[RemainingCount] = scala
      .Option(impl.remainingCount())
      .map(value => zio.aws.ssm.model.primitives.RemainingCount(value))
    override val summaryItems: Option[
      List[zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly]
    ] = scala
      .Option(impl.summaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InventoryDeletionSummaryItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary
  ): zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly = new Wrapper(impl)
}
