package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters.*
final case class OpsItemSummary(
    createdBy: Option[String] = None,
    createdTime: Option[DateTime] = None,
    lastModifiedBy: Option[String] = None,
    lastModifiedTime: Option[DateTime] = None,
    priority: Option[OpsItemPriority] = None,
    source: Option[OpsItemSource] = None,
    status: Option[zio.aws.ssm.model.OpsItemStatus] = None,
    opsItemId: Option[OpsItemId] = None,
    title: Option[OpsItemTitle] = None,
    operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = None,
    category: Option[OpsItemCategory] = None,
    severity: Option[OpsItemSeverity] = None,
    opsItemType: Option[OpsItemType] = None,
    actualStartTime: Option[DateTime] = None,
    actualEndTime: Option[DateTime] = None,
    plannedStartTime: Option[DateTime] = None,
    plannedEndTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemSummary = {
    import OpsItemSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemSummary
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        source.map(value => OpsItemSource.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemSummary.ReadOnly =
    zio.aws.ssm.model.OpsItemSummary.wrap(buildAwsValue())
}
object OpsItemSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemSummary =
      zio.aws.ssm.model.OpsItemSummary(
        createdBy.map(value => value),
        createdTime.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedTime.map(value => value),
        priority.map(value => value),
        source.map(value => value),
        status.map(value => value),
        opsItemId.map(value => value),
        title.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        category.map(value => value),
        severity.map(value => value),
        opsItemType.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value)
      )
    def createdBy: Option[String]
    def createdTime: Option[DateTime]
    def lastModifiedBy: Option[String]
    def lastModifiedTime: Option[DateTime]
    def priority: Option[OpsItemPriority]
    def source: Option[OpsItemSource]
    def status: Option[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: Option[OpsItemId]
    def title: Option[OpsItemTitle]
    def operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def category: Option[OpsItemCategory]
    def severity: Option[OpsItemSeverity]
    def opsItemType: Option[OpsItemType]
    def actualStartTime: Option[DateTime]
    def actualEndTime: Option[DateTime]
    def plannedStartTime: Option[DateTime]
    def plannedEndTime: Option[DateTime]
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSource: ZIO[Any, AwsError, OpsItemSource] =
      AwsError.unwrapOptionField("source", source)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ) extends zio.aws.ssm.model.OpsItemSummary.ReadOnly {
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val createdTime: Option[DateTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedBy: Option[String] =
      scala.Option(impl.lastModifiedBy()).map(value => value: String)
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val priority: Option[OpsItemPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val source: Option[OpsItemSource] = scala
      .Option(impl.source())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSource(value))
    override val status: Option[zio.aws.ssm.model.OpsItemStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: Option[OpsItemId] = scala
      .Option(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val title: Option[OpsItemTitle] = scala
      .Option(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = scala
      .Option(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val category: Option[OpsItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Option[OpsItemSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val opsItemType: Option[OpsItemType] = scala
      .Option(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val actualStartTime: Option[DateTime] = scala
      .Option(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Option[DateTime] = scala
      .Option(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Option[DateTime] = scala
      .Option(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Option[DateTime] = scala
      .Option(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ): zio.aws.ssm.model.OpsItemSummary.ReadOnly = new Wrapper(impl)
}
