package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, PSParameterName}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetParameterHistoryRequest(
    name: PSParameterName,
    withDecryption: Option[Boolean] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest = {
    import GetParameterHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .optionallyWith(withDecryption.map(value => value: java.lang.Boolean))(
        _.withDecryption
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly =
    zio.aws.ssm.model.GetParameterHistoryRequest.wrap(buildAwsValue())
}
object GetParameterHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParameterHistoryRequest =
      zio.aws.ssm.model.GetParameterHistoryRequest(
        name,
        withDecryption.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: PSParameterName
    def withDecryption: Option[Boolean]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getWithDecryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withDecryption", withDecryption)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ) extends zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val withDecryption: Option[Boolean] =
      scala.Option(impl.withDecryption()).map(value => value: Boolean)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ): zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly = new Wrapper(impl)
}
