package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, PatchBaselineMaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePatchGroupsRequest(
    maxResults: Option[PatchBaselineMaxResults] = None,
    filters: Option[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest = {
    import DescribePatchGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupsRequest.wrap(buildAwsValue())
}
object DescribePatchGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupsRequest =
      zio.aws.ssm.model.DescribePatchGroupsRequest(
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def maxResults: Option[PatchBaselineMaxResults]
    def filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ) extends zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly {
    override val maxResults: Option[PatchBaselineMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value))
    override val filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest
  ): zio.aws.ssm.model.DescribePatchGroupsRequest.ReadOnly = new Wrapper(impl)
}
