package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaintenanceWindowSearchMaxResults
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowsForTargetRequest(
    targets: Iterable[zio.aws.ssm.model.Target],
    resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType,
    maxResults: Option[MaintenanceWindowSearchMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest = {
    import DescribeMaintenanceWindowsForTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest
      .builder()
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          MaintenanceWindowSearchMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowsForTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest =
      zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest(
        targets.map { item =>
          item.asEditable
        },
        resourceType,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def targets: List[zio.aws.ssm.model.Target.ReadOnly]
    def resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType
    def maxResults: Option[MaintenanceWindowSearchMaxResults]
    def nextToken: Option[NextToken]
    def getTargets: ZIO[Any, Nothing, List[zio.aws.ssm.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ssm.model.MaintenanceWindowResourceType] =
      ZIO.succeed(resourceType)
    def getMaxResults: ZIO[Any, AwsError, MaintenanceWindowSearchMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest.ReadOnly {
    override val targets: List[zio.aws.ssm.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.ssm.model.Target.wrap(item)
      }
      .toList
    override val resourceType: zio.aws.ssm.model.MaintenanceWindowResourceType =
      zio.aws.ssm.model.MaintenanceWindowResourceType.wrap(impl.resourceType())
    override val maxResults: Option[MaintenanceWindowSearchMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowSearchMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ): zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest.ReadOnly =
    new Wrapper(impl)
}
