package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MetadataKey, OpsMetadataResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOpsMetadataRequest(
    resourceId: OpsMetadataResourceId,
    metadata: Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue]] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest = {
    import CreateOpsMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest
      .builder()
      .resourceId(OpsMetadataResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateOpsMetadataRequest.ReadOnly =
    zio.aws.ssm.model.CreateOpsMetadataRequest.wrap(buildAwsValue())
}
object CreateOpsMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateOpsMetadataRequest =
      zio.aws.ssm.model.CreateOpsMetadataRequest(
        resourceId,
        metadata.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceId: OpsMetadataResourceId
    def metadata
        : Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getResourceId: ZIO[Any, Nothing, OpsMetadataResourceId] =
      ZIO.succeed(resourceId)
    def getMetadata: ZIO[Any, AwsError, Map[
      MetadataKey,
      zio.aws.ssm.model.MetadataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("metadata", metadata)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest
  ) extends zio.aws.ssm.model.CreateOpsMetadataRequest.ReadOnly {
    override val resourceId: OpsMetadataResourceId =
      zio.aws.ssm.model.primitives.OpsMetadataResourceId(impl.resourceId())
    override val metadata
        : Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]] =
      scala
        .Option(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .MetadataKey(key) -> zio.aws.ssm.model.MetadataValue.wrap(value)
            })
            .toMap
        )
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest
  ): zio.aws.ssm.model.CreateOpsMetadataRequest.ReadOnly = new Wrapper(impl)
}
