package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStringDateTime,
  MaintenanceWindowOffset,
  MaintenanceWindowId,
  MaintenanceWindowTimezone,
  MaintenanceWindowCutoff,
  MaintenanceWindowSchedule,
  MaintenanceWindowDurationHours,
  MaintenanceWindowEnabled,
  MaintenanceWindowName,
  MaintenanceWindowAllowUnassociatedTargets,
  MaintenanceWindowDescription
}
import scala.jdk.CollectionConverters._
final case class UpdateMaintenanceWindowResponse(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent,
    name: Optional[MaintenanceWindowName] = Optional.Absent,
    description: Optional[MaintenanceWindowDescription] = Optional.Absent,
    startDate: Optional[MaintenanceWindowStringDateTime] = Optional.Absent,
    endDate: Optional[MaintenanceWindowStringDateTime] = Optional.Absent,
    schedule: Optional[MaintenanceWindowSchedule] = Optional.Absent,
    scheduleTimezone: Optional[MaintenanceWindowTimezone] = Optional.Absent,
    scheduleOffset: Optional[MaintenanceWindowOffset] = Optional.Absent,
    duration: Optional[MaintenanceWindowDurationHours] = Optional.Absent,
    cutoff: Optional[MaintenanceWindowCutoff] = Optional.Absent,
    allowUnassociatedTargets: Optional[
      MaintenanceWindowAllowUnassociatedTargets
    ] = Optional.Absent,
    enabled: Optional[MaintenanceWindowEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse = {
    import UpdateMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.startDate)
      .optionallyWith(
        endDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.endDate)
      .optionallyWith(
        schedule.map(value =>
          MaintenanceWindowSchedule.unwrap(value): java.lang.String
        )
      )(_.schedule)
      .optionallyWith(
        scheduleTimezone.map(value =>
          MaintenanceWindowTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleTimezone)
      .optionallyWith(
        scheduleOffset.map(value =>
          MaintenanceWindowOffset.unwrap(value): Integer
        )
      )(_.scheduleOffset)
      .optionallyWith(
        duration.map(value =>
          MaintenanceWindowDurationHours.unwrap(value): Integer
        )
      )(_.duration)
      .optionallyWith(
        cutoff.map(value => MaintenanceWindowCutoff.unwrap(value): Integer)
      )(_.cutoff)
      .optionallyWith(
        allowUnassociatedTargets.map(value =>
          MaintenanceWindowAllowUnassociatedTargets.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.allowUnassociatedTargets)
      .optionallyWith(
        enabled.map(value =>
          MaintenanceWindowEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.UpdateMaintenanceWindowResponse.wrap(buildAwsValue())
}
object UpdateMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateMaintenanceWindowResponse =
      zio.aws.ssm.model.UpdateMaintenanceWindowResponse(
        windowId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        schedule.map(value => value),
        scheduleTimezone.map(value => value),
        scheduleOffset.map(value => value),
        duration.map(value => value),
        cutoff.map(value => value),
        allowUnassociatedTargets.map(value => value),
        enabled.map(value => value)
      )
    def windowId: Optional[MaintenanceWindowId]
    def name: Optional[MaintenanceWindowName]
    def description: Optional[MaintenanceWindowDescription]
    def startDate: Optional[MaintenanceWindowStringDateTime]
    def endDate: Optional[MaintenanceWindowStringDateTime]
    def schedule: Optional[MaintenanceWindowSchedule]
    def scheduleTimezone: Optional[MaintenanceWindowTimezone]
    def scheduleOffset: Optional[MaintenanceWindowOffset]
    def duration: Optional[MaintenanceWindowDurationHours]
    def cutoff: Optional[MaintenanceWindowCutoff]
    def allowUnassociatedTargets
        : Optional[MaintenanceWindowAllowUnassociatedTargets]
    def enabled: Optional[MaintenanceWindowEnabled]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getSchedule: ZIO[Any, AwsError, MaintenanceWindowSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getScheduleTimezone: ZIO[Any, AwsError, MaintenanceWindowTimezone] =
      AwsError.unwrapOptionField("scheduleTimezone", scheduleTimezone)
    def getScheduleOffset: ZIO[Any, AwsError, MaintenanceWindowOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getDuration: ZIO[Any, AwsError, MaintenanceWindowDurationHours] =
      AwsError.unwrapOptionField("duration", duration)
    def getCutoff: ZIO[Any, AwsError, MaintenanceWindowCutoff] =
      AwsError.unwrapOptionField("cutoff", cutoff)
    def getAllowUnassociatedTargets
        : ZIO[Any, AwsError, MaintenanceWindowAllowUnassociatedTargets] =
      AwsError.unwrapOptionField(
        "allowUnassociatedTargets",
        allowUnassociatedTargets
      )
    def getEnabled: ZIO[Any, AwsError, MaintenanceWindowEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val name: Optional[MaintenanceWindowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Optional[MaintenanceWindowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
        )
    override val startDate: Optional[MaintenanceWindowStringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
    override val endDate: Optional[MaintenanceWindowStringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDate())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
    override val schedule: Optional[MaintenanceWindowSchedule] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowSchedule(value)
        )
    override val scheduleTimezone: Optional[MaintenanceWindowTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleTimezone())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTimezone(value)
        )
    override val scheduleOffset: Optional[MaintenanceWindowOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleOffset())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowOffset(value)
        )
    override val duration: Optional[MaintenanceWindowDurationHours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.duration())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDurationHours(value)
        )
    override val cutoff: Optional[MaintenanceWindowCutoff] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cutoff())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowCutoff(value)
        )
    override val allowUnassociatedTargets
        : Optional[MaintenanceWindowAllowUnassociatedTargets] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowUnassociatedTargets())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowAllowUnassociatedTargets(value)
        )
    override val enabled: Optional[MaintenanceWindowEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabled())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowEnabled(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse
  ): zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly = new Wrapper(
    impl
  )
}
