package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchGroup, BaselineId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterPatchBaselineForPatchGroupRequest(
    baselineId: BaselineId,
    patchGroup: PatchGroup
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest = {
    import RegisterPatchBaselineForPatchGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest.ReadOnly =
    zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest
      .wrap(buildAwsValue())
}
object RegisterPatchBaselineForPatchGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest =
      zio.aws.ssm.model
        .RegisterPatchBaselineForPatchGroupRequest(baselineId, patchGroup)
    def baselineId: BaselineId
    def patchGroup: PatchGroup
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest
  ) extends zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest
  ): zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest.ReadOnly =
    new Wrapper(impl)
}
