package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  PatchComplianceMaxResults,
  NextToken,
  PatchGroup
}
import scala.jdk.CollectionConverters._
final case class DescribeInstancePatchStatesForPatchGroupRequest(
    patchGroup: PatchGroup,
    filters: Optional[Iterable[zio.aws.ssm.model.InstancePatchStateFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[PatchComplianceMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest = {
    import DescribeInstancePatchStatesForPatchGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
      .builder()
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          PatchComplianceMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
      .wrap(buildAwsValue())
}
object DescribeInstancePatchStatesForPatchGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest =
      zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest(
        patchGroup,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def patchGroup: PatchGroup
    def filters
        : Optional[List[zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[PatchComplianceMaxResults]
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PatchComplianceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ) extends zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly {
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
    override val filters
        : Optional[List[zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InstancePatchStateFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[PatchComplianceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchComplianceMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest.ReadOnly =
    new Wrapper(impl)
}
